/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.INotify;
import dorkbox.notify.LookAndFeel;
import dorkbox.notify.Notify;
import dorkbox.notify.NotifyCanvas;
import dorkbox.notify.Theme;
import dorkbox.util.ScreenUtil;
import dorkbox.util.SwingUtil;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JWindow;

public class AsDesktop
extends JWindow
implements INotify {
    private static final long serialVersionUID = 1L;
    private final LookAndFeel look;
    private final Notify notification;

    AsDesktop(Notify notification, ImageIcon image, Theme theme) {
        GraphicsDevice device;
        this.notification = notification;
        this.setAlwaysOnTop(true);
        Dimension preferredSize = new Dimension(1, 2);
        this.setPreferredSize(preferredSize);
        this.setMaximumSize(preferredSize);
        this.setMinimumSize(preferredSize);
        this.setSize(300, 87);
        this.setLocation(Short.MIN_VALUE, Short.MIN_VALUE);
        if (notification.screenNumber == Short.MIN_VALUE) {
            Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
            device = ScreenUtil.getMonitorAtLocation(mouseLocation);
        } else {
            int screenNumber = notification.screenNumber;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] screenDevices = ge.getScreenDevices();
            if (screenNumber < 0) {
                screenNumber = 0;
            } else if (screenNumber > screenDevices.length - 1) {
                screenNumber = screenDevices.length - 1;
            }
            device = screenDevices[screenNumber];
        }
        Rectangle bounds = device.getDefaultConfiguration().getBounds();
        NotifyCanvas notifyCanvas = new NotifyCanvas(this, notification, image, theme);
        this.getContentPane().add(notifyCanvas);
        this.look = new LookAndFeel(this, this, notifyCanvas, notification, bounds, true);
    }

    @Override
    public void onClick(int x, int y) {
        this.look.onClick(x, y);
    }

    @Override
    public void shake(int durationInMillis, int amplitude) {
        this.look.shake(durationInMillis, amplitude);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        this.look.updatePositionsPre(visible);
        super.setVisible(visible);
        this.look.updatePositionsPost(visible);
        if (visible) {
            this.toFront();
        }
    }

    void doHide() {
        super.setVisible(false);
    }

    @Override
    public void close() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                AsDesktop.this.doHide();
                AsDesktop.this.look.close();
                AsDesktop.this.removeAll();
                AsDesktop.this.dispose();
                AsDesktop.this.notification.onClose();
            }
        });
    }
}

