/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.ClickAdapter;
import dorkbox.notify.INotify;
import dorkbox.notify.Notify;
import dorkbox.notify.NotifyAccessor;
import dorkbox.notify.NotifyCanvas;
import dorkbox.notify.PopupList;
import dorkbox.notify.Pos;
import dorkbox.notify.WindowAdapter;
import dorkbox.tweenEngine.BaseTween;
import dorkbox.tweenEngine.Tween;
import dorkbox.tweenEngine.TweenCallback;
import dorkbox.tweenEngine.TweenEngine;
import dorkbox.tweenEngine.TweenEquations;
import dorkbox.util.ActionHandler;
import dorkbox.util.ActionHandlerLong;
import dorkbox.util.ScreenUtil;
import dorkbox.util.swing.SwingActiveRender;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

class LookAndFeel {
    private static final Map<String, PopupList> popups = new HashMap<String, PopupList>();
    static final TweenEngine animation = TweenEngine.create().unsafe().build();
    static final NotifyAccessor accessor = new NotifyAccessor();
    private static final ActionHandlerLong frameStartHandler = new ActionHandlerLong(){

        @Override
        public void handle(long deltaInNanos) {
            animation.update(deltaInNanos);
        }
    };
    static final int SPACER = 10;
    static final int MARGIN = 20;
    private static final java.awt.event.WindowAdapter windowListener = new WindowAdapter();
    private static final MouseAdapter mouseListener = new ClickAdapter();
    private static final Random RANDOM = new Random();
    private static final float MOVE_DURATION = Notify.MOVE_DURATION;
    private final boolean isDesktopNotification;
    private volatile int anchorX;
    private volatile int anchorY;
    private final INotify notify;
    private final Window parent;
    private final NotifyCanvas notifyCanvas;
    private final float hideAfterDurationInSeconds;
    private final Pos position;
    private final String idAndPosition;
    private int popupIndex;
    private volatile Tween tween = null;
    private volatile Tween hideTween = null;
    private final ActionHandler<Notify> onGeneralAreaClickAction;

    LookAndFeel(INotify notify, Window parent, NotifyCanvas notifyCanvas, final Notify notification, Rectangle parentBounds, boolean isDesktopNotification) {
        this.notify = notify;
        this.parent = parent;
        this.notifyCanvas = notifyCanvas;
        this.isDesktopNotification = isDesktopNotification;
        if (isDesktopNotification) {
            parent.addWindowListener(windowListener);
        }
        notifyCanvas.addMouseListener(mouseListener);
        this.hideAfterDurationInSeconds = (float)notification.hideAfterDurationInMillis / 1000.0f;
        this.position = notification.position;
        this.onGeneralAreaClickAction = notification.onGeneralAreaClickAction != null ? new ActionHandler<Notify>(){

            @Override
            public void handle(Notify value) {
                notification.onGeneralAreaClickAction.handle(notification);
            }
        } : null;
        if (isDesktopNotification) {
            Point point = new Point((int)parentBounds.getX(), (int)parentBounds.getY());
            this.idAndPosition = ScreenUtil.getMonitorNumberAtLocation(point) + ":" + (Object)((Object)this.position);
        } else {
            this.idAndPosition = parent.getName() + ":" + (Object)((Object)this.position);
        }
        this.anchorX = LookAndFeel.getAnchorX(this.position, parentBounds, isDesktopNotification);
        this.anchorY = LookAndFeel.getAnchorY(this.position, parentBounds, isDesktopNotification);
    }

    void onClick(int x, int y) {
        if (!this.notifyCanvas.isCloseButton(x, y) && this.onGeneralAreaClickAction != null) {
            this.onGeneralAreaClickAction.handle(null);
        }
        this.notify.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reLayout(Rectangle bounds) {
        int changedY;
        this.anchorX = LookAndFeel.getAnchorX(this.position, bounds, this.isDesktopNotification);
        this.anchorY = LookAndFeel.getAnchorY(this.position, bounds, this.isDesktopNotification);
        boolean showFromTop = LookAndFeel.isShowFromTop(this);
        if (this.tween != null) {
            this.tween.cancel();
            this.tween = null;
        }
        if (this.popupIndex == 0) {
            changedY = this.anchorY;
        } else {
            Map<String, PopupList> map = popups;
            synchronized (map) {
                String id = this.idAndPosition;
                PopupList looks = popups.get(id);
                changedY = looks != null ? (showFromTop ? this.anchorY + this.popupIndex * 97 : this.anchorY - this.popupIndex * 97) : this.anchorY;
            }
        }
        this.setLocation(this.anchorX, changedY);
    }

    void close() {
        if (this.hideTween != null) {
            this.hideTween.cancel();
            this.hideTween = null;
        }
        if (this.tween != null) {
            this.tween.cancel();
            this.tween = null;
        }
        if (this.isDesktopNotification) {
            this.parent.removeWindowListener(windowListener);
        }
        this.parent.removeMouseListener(mouseListener);
        this.updatePositionsPre(false);
        this.updatePositionsPost(false);
    }

    void shake(int durationInMillis, int amplitude) {
        int i1 = RANDOM.nextInt((amplitude << 2) + 1) - amplitude;
        int i2 = RANDOM.nextInt((amplitude << 2) + 1) - amplitude;
        i2 >>= 2;
        i1 = (i1 >>= 2) < 0 ? (i1 -= amplitude >> 2) : (i1 += amplitude >> 2);
        i2 = i2 < 0 ? (i2 -= amplitude >> 2) : (i2 += amplitude >> 2);
        int count = durationInMillis / 50;
        if ((count & 1) == 0) {
            ++count;
        }
        ((Tween)animation.to(this, 2, accessor, 0.05f).targetRelative((float)i1, (float)i2).repeatAutoReverse(count, 0.0f)).ease(TweenEquations.Linear).start();
    }

    void setY(int y) {
        if (this.isDesktopNotification) {
            this.parent.setLocation(this.parent.getX(), y);
        } else {
            this.notifyCanvas.setLocation(this.notifyCanvas.getX(), y);
        }
    }

    int getY() {
        if (this.isDesktopNotification) {
            return this.parent.getY();
        }
        return this.notifyCanvas.getY();
    }

    int getX() {
        if (this.isDesktopNotification) {
            return this.parent.getX();
        }
        return this.notifyCanvas.getX();
    }

    void setLocation(int x, int y) {
        if (this.isDesktopNotification) {
            this.parent.setLocation(x, y);
        } else {
            this.notifyCanvas.setLocation(x, y);
        }
    }

    private static int getAnchorX(Pos position, Rectangle bounds, boolean isDesktop) {
        int startX = isDesktop ? (int)bounds.getX() : 0;
        int screenWidth = (int)bounds.getWidth();
        switch (position) {
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                return 20 + startX;
            }
            case CENTER: {
                return startX + screenWidth / 2 - 150 - 10;
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return startX + screenWidth - 300 - 20;
            }
        }
        throw new RuntimeException("Unknown position. '" + (Object)((Object)position) + "'");
    }

    private static int getAnchorY(Pos position, Rectangle bounds, boolean isDesktop) {
        int startY = isDesktop ? (int)bounds.getY() : 0;
        int screenHeight = (int)bounds.getHeight();
        switch (position) {
            case TOP_LEFT: 
            case TOP_RIGHT: {
                return startY + 20;
            }
            case CENTER: {
                return startY + screenHeight / 2 - 43 - 10 - 10;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                if (isDesktop) {
                    return startY + screenHeight - 87 - 20;
                }
                return startY + screenHeight - 87 - 20 - 20;
            }
        }
        throw new RuntimeException("Unknown position. '" + (Object)((Object)position) + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPopupToMap(final LookAndFeel sourceLook) {
        Map<String, PopupList> map = popups;
        synchronized (map) {
            int targetY;
            int index;
            String id = sourceLook.idAndPosition;
            PopupList looks = popups.get(id);
            if (looks == null) {
                looks = new PopupList();
                popups.put(id, looks);
            }
            sourceLook.popupIndex = index = looks.size();
            int anchorX = sourceLook.anchorX;
            int anchorY = sourceLook.anchorY;
            if (index == 0) {
                targetY = anchorY;
            } else {
                boolean showFromTop = LookAndFeel.isShowFromTop(sourceLook);
                if (sourceLook.isDesktopNotification && index == 1) {
                    looks.calculateOffset(showFromTop, anchorX, anchorY);
                }
                targetY = showFromTop ? anchorY + index * 97 + looks.getOffsetY() : anchorY - index * 97 + looks.getOffsetY();
            }
            looks.add(sourceLook);
            sourceLook.setLocation(anchorX, targetY);
            if (sourceLook.hideAfterDurationInSeconds > 0.0f && sourceLook.hideTween == null) {
                ((Tween)animation.to(sourceLook, 3, accessor, sourceLook.hideAfterDurationInSeconds).target(300.0f).ease(TweenEquations.Linear).addCallback(new TweenCallback(){

                    @Override
                    public void onEvent(int type, BaseTween<?> source) {
                        if (type == 8) {
                            sourceLook.notify.close();
                        }
                    }
                })).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removePopupFromMap(LookAndFeel sourceLook) {
        boolean popupsAreEmpty;
        boolean showFromTop = LookAndFeel.isShowFromTop(sourceLook);
        Map<String, PopupList> map = popups;
        synchronized (map) {
            popupsAreEmpty = popups.isEmpty();
            PopupList allLooks = popups.get(sourceLook.idAndPosition);
            boolean adjustPopupPosition = false;
            Iterator<LookAndFeel> iterator = allLooks.iterator();
            while (iterator.hasNext()) {
                LookAndFeel look = iterator.next();
                if (look.tween != null) {
                    look.tween.cancel();
                    look.tween = null;
                }
                if (look == sourceLook) {
                    if (look.hideTween != null) {
                        look.hideTween.cancel();
                        look.hideTween = null;
                    }
                    adjustPopupPosition = true;
                    iterator.remove();
                }
                if (!adjustPopupPosition) continue;
                --look.popupIndex;
            }
            int offsetY = allLooks.getOffsetY();
            for (int index = 0; index < allLooks.size(); ++index) {
                final LookAndFeel look = allLooks.get(index);
                int changedY = showFromTop ? look.anchorY + (look.popupIndex * 97 + offsetY) : look.anchorY - (look.popupIndex * 97 + offsetY);
                look.tween = (Tween)((Tween)animation.to(look, 1, accessor, MOVE_DURATION).target((float)changedY).ease(TweenEquations.Linear).addCallback(new TweenCallback(){

                    @Override
                    public void onEvent(int type, BaseTween<?> source) {
                        if (type == 8) {
                            look.tween = null;
                        }
                    }
                })).start();
            }
        }
        return popupsAreEmpty;
    }

    private static boolean isShowFromTop(LookAndFeel look) {
        switch (look.position) {
            case TOP_LEFT: 
            case CENTER: 
            case TOP_RIGHT: {
                return true;
            }
        }
        return false;
    }

    void setProgress(int progress) {
        this.notifyCanvas.setProgress(progress);
    }

    int getProgress() {
        return this.notifyCanvas.getProgress();
    }

    void updatePositionsPre(boolean visible) {
        if (!visible) {
            boolean popupsAreEmpty = LookAndFeel.removePopupFromMap(this);
            SwingActiveRender.removeActiveRender(this.notifyCanvas);
            if (popupsAreEmpty) {
                SwingActiveRender.removeActiveRenderFrameStart(frameStartHandler);
            }
        }
    }

    void updatePositionsPost(boolean visible) {
        if (visible) {
            SwingActiveRender.addActiveRender(this.notifyCanvas);
            if (!SwingActiveRender.containsActiveRenderFrameStart(frameStartHandler)) {
                animation.resetUpdateTime();
                SwingActiveRender.addActiveRenderFrameStart(frameStartHandler);
            }
            LookAndFeel.addPopupToMap(this);
        }
    }
}

