/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.notify;

import dorkbox.notify.INotify;
import dorkbox.notify.Notify;
import dorkbox.notify.Theme;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class NotifyCanvas
extends Canvas {
    private static final Stroke stroke = new BasicStroke(2.0f);
    private static final int closeX = 282;
    private static final int closeY = 2;
    private static final int Y_1 = 7;
    private static final int X_1 = 287;
    private static final int Y_2 = 13;
    private static final int X_2 = 293;
    static final int WIDTH = 300;
    static final int HEIGHT = 87;
    private static final int PROGRESS_HEIGHT = 85;
    private final boolean showCloseButton;
    private BufferedImage cachedImage;
    private final Notify notification;
    private final ImageIcon imageIcon;
    private int progress = 0;
    private final Theme theme;
    final INotify parent;

    NotifyCanvas(INotify parent, Notify notification, ImageIcon imageIcon, Theme theme) {
        this.parent = parent;
        this.notification = notification;
        this.imageIcon = imageIcon;
        this.theme = theme;
        Dimension preferredSize = new Dimension(300, 87);
        this.setPreferredSize(preferredSize);
        this.setMaximumSize(preferredSize);
        this.setMinimumSize(preferredSize);
        this.setSize(300, 87);
        this.setFocusable(false);
        this.setBackground(this.theme.panel_BG);
        this.showCloseButton = !notification.hideCloseButton;
        this.cachedImage = NotifyCanvas.renderBackgroundInfo(notification.title, notification.text, this.theme, this.imageIcon);
    }

    void setProgress(int progress) {
        this.progress = progress;
    }

    int getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        try {
            g.drawImage(this.cachedImage, 0, 0, null);
        }
        catch (Exception ignored) {
            this.cachedImage = NotifyCanvas.renderBackgroundInfo(this.notification.title, this.notification.text, this.theme, this.imageIcon);
            try {
                g.drawImage(this.cachedImage, 0, 0, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            if (this.showCloseButton) {
                Graphics2D g3 = (Graphics2D)g.create();
                g3.setColor(this.theme.panel_BG);
                g3.setStroke(stroke);
                Point p = this.getMousePosition();
                if (p != null && p.getX() >= 280.0 && p.getY() <= 20.0) {
                    g3.setColor(Color.RED);
                } else {
                    g3.setColor(this.theme.closeX_FG);
                }
                g3.drawLine(287, 7, 293, 13);
                g3.drawLine(293, 7, 287, 13);
            }
            g2.setColor(this.theme.progress_FG);
            g2.fillRect(0, 85, this.progress, 2);
        }
        finally {
            g2.dispose();
        }
    }

    boolean isCloseButton(int x, int y) {
        return this.showCloseButton && x >= 280 && y <= 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage renderBackgroundInfo(String title, String notificationText, Theme theme, ImageIcon imageIcon) {
        BufferedImage image = new BufferedImage(300, 87, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        try {
            g2.setColor(theme.panel_BG);
            g2.fillRect(0, 0, 300, 87);
            g2.setColor(theme.titleText_FG);
            g2.setFont(theme.titleTextFont);
            g2.drawString(title, 5, 20);
            int posX = 10;
            int posY = -8;
            int textLengthLimit = 108;
            if (imageIcon != null) {
                textLengthLimit = 88;
                posX = 60;
                imageIcon.paintIcon(null, g2, 5, 30);
            }
            int length = notificationText.length();
            StringBuilder text = new StringBuilder(length);
            if (length >= 13 && notificationText.regionMatches(true, length - 7, "</html>", 0, 7)) {
                text.append(notificationText);
                text.delete(text.length() - 7, text.length());
                length -= 7;
            } else {
                text.append("<html>");
                text.append(notificationText);
            }
            if (length > textLengthLimit) {
                text.delete(6 + textLengthLimit, text.length());
                text.append("...");
            }
            text.append("</html>");
            JLabel mainTextLabel = new JLabel();
            mainTextLabel.setForeground(theme.mainText_FG);
            mainTextLabel.setFont(theme.mainTextFont);
            mainTextLabel.setText(text.toString());
            mainTextLabel.setBounds(0, 0, 300 - posX - 2, 87);
            g2.translate(posX, posY);
            mainTextLabel.paint(g2);
            g2.translate(-posX, -posY);
        }
        finally {
            g2.dispose();
        }
        return image;
    }
}

