/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.notifier;

import com.shaded.notifier.google.common.base.Stopwatch;
import fr.jcgay.maven.notifier.Configuration;
import fr.jcgay.maven.notifier.Notifier;
import fr.jcgay.maven.notifier.Status;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractNotifier
implements Notifier {
    protected Logger logger;
    protected Configuration configuration;
    private Stopwatch stopwatch = Stopwatch.createUnstarted();

    protected abstract void fireNotification(MavenExecutionResult var1);

    @Override
    public final void init(EventSpy.Context context) {
        this.stopwatch.start();
        this.configuration = (Configuration)context.getData().get("notifier.configuration");
        if (!context.getData().containsKey("notifier.skip.init")) {
            this.initNotifier();
        }
    }

    @Override
    public final void onEvent(MavenExecutionResult event) {
        this.stopwatch.stop();
        if (this.stopwatch.elapsed(TimeUnit.SECONDS) > (long)this.configuration.getThreshold() || this.isPersistent()) {
            this.fireNotification(event);
        } else {
            this.logger.debug("No notification sent because build ends before threshold: " + this.configuration.getThreshold() + "s.");
        }
    }

    @Override
    public final void close() {
        this.stopwatch.reset();
        this.closeNotifier();
    }

    @Override
    public void onFailWithoutProject(List<Throwable> exceptions) {
    }

    @Override
    public boolean isCandidateFor(String desiredImplementation) {
        return this.getClass().getName().contains(desiredImplementation);
    }

    @Requirement
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setStopwatch(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    protected void initNotifier() {
    }

    protected void closeNotifier() {
    }

    protected Status getBuildStatus(MavenExecutionResult result) {
        return result.hasExceptions() ? Status.FAILURE : Status.SUCCESS;
    }

    protected long elapsedTime() {
        return this.stopwatch.elapsed(TimeUnit.SECONDS);
    }

    protected boolean isPersistent() {
        return false;
    }
}

