/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.notifier;

import com.shaded.notifier.google.common.annotations.VisibleForTesting;
import fr.jcgay.maven.notifier.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=ConfigurationParser.class, hint="maven-notifier-configuration")
public class ConfigurationParser {
    @Requirement
    private Logger logger;

    public ConfigurationParser() {
    }

    public ConfigurationParser(Logger logger) {
        this.logger = logger;
    }

    public Configuration get() {
        return this.get(this.globalConfiguration(), this.userConfiguration());
    }

    public Configuration get(URL ... urls) {
        return this.get(this.readProperties(urls));
    }

    @VisibleForTesting
    Configuration get(Properties properties) {
        Configuration configuration = this.parse(new ConfigurationProperties(properties));
        this.logger.debug("maven-notifier user configuration: " + configuration);
        return configuration;
    }

    private Properties readProperties(URL ... urls) {
        return new ConfiguredProperties(this.logger).load(urls).properties();
    }

    private URL globalConfiguration() {
        try {
            URL url = new URL(ConfigurationParser.class.getProtectionDomain().getCodeSource().getLocation(), "maven-notifier.properties");
            this.logger.debug("Global configuration is located at: " + url);
            return url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private URL userConfiguration() {
        try {
            URL url = new URL("file:///" + System.getProperty("user.home") + "/.m2/maven-notifier.properties");
            this.logger.debug("User specific configuration is located at: " + url);
            return url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private Configuration parse(ConfigurationProperties properties) {
        Configuration configuration = new Configuration();
        configuration.setImplementation(properties.get(ConfigurationProperties.Property.IMPLEMENTATION));
        configuration.setShortDescription(Boolean.parseBoolean(properties.get(ConfigurationProperties.Property.SHORT_DESCRIPTION)));
        configuration.setThreshold(Integer.valueOf(properties.get(ConfigurationProperties.Property.THRESHOLD)));
        configuration.setTimeout(Integer.valueOf(properties.get(ConfigurationProperties.Property.TIMEOUT)));
        configuration.setNotifierProperties(properties.all());
        return configuration;
    }

    private static class ConfiguredProperties {
        private final Logger logger;
        private final Properties properties = new Properties();

        public ConfiguredProperties(Logger logger) {
            this.logger = logger;
        }

        public Properties properties() {
            Properties result = new Properties();
            result.putAll((Map<?, ?>)this.properties);
            for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
                if (!property.getKey().toString().startsWith("notifier.")) continue;
                result.put(property.getKey(), property.getValue());
            }
            String overrideImplementation = System.getProperty(ConfigurationProperties.Property.NOTIFY_WITH.key());
            if (overrideImplementation != null) {
                this.logger.debug("Overriding configured notifier with: " + overrideImplementation);
                result.put(ConfigurationProperties.Property.IMPLEMENTATION.key(), overrideImplementation);
            }
            return result;
        }

        public ConfiguredProperties load(URL ... urls) {
            for (URL url : urls) {
                if (url == null) continue;
                try (InputStream in = url.openStream();){
                    this.properties.load(in);
                    this.logger.debug("Properties after loading [" + url + "]: " + this.properties);
                }
                catch (IOException e) {
                    this.logger.debug("Can't read file at [" + url + "]. Skipping it...", (Throwable)e);
                }
            }
            return this;
        }
    }

    public static class ConfigurationProperties {
        private final Properties properties;

        private ConfigurationProperties(Properties properties) {
            this.properties = properties;
        }

        public String get(Property property) {
            switch (property) {
                case IMPLEMENTATION: {
                    return this.properties.getProperty(property.key(), "send-notification");
                }
            }
            return this.properties.getProperty(property.key(), property.defaultValue());
        }

        public Properties all() {
            return this.properties;
        }

        public static enum Property {
            IMPLEMENTATION("notifier.implementation"),
            SHORT_DESCRIPTION("notifier.message.short", "true"),
            NOTIFY_WITH("notifyWith"),
            THRESHOLD("notifier.threshold", "-1"),
            TIMEOUT("notifier.timeout", "-1");

            private final String key;
            private String defaultValue;

            private Property(String key) {
                this.key = key;
            }

            private Property(String key, String defaultValue) {
                this.key = key;
                this.defaultValue = defaultValue;
            }

            public String key() {
                return this.key;
            }

            public String defaultValue() {
                return this.defaultValue;
            }
        }
    }
}

