/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.notifier;

import com.shaded.notifier.google.common.base.MoreObjects;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final String UNKNOWN_VERSION = "unknown-version";
    private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
    private final String source;

    Version(String classpathResource) {
        this.source = classpathResource;
    }

    public static Version current() {
        return new Version("/version");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get() {
        InputStream resource = Version.class.getResourceAsStream(this.source);
        if (resource == null) {
            return UNKNOWN_VERSION;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
            String string = MoreObjects.firstNonNull(reader.readLine(), UNKNOWN_VERSION);
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("Error while trying to read current maven-notifier version.", (Throwable)e);
            return UNKNOWN_VERSION;
        }
    }
}

