/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.notifier.sound;

import fr.jcgay.maven.notifier.AbstractNotifier;
import fr.jcgay.maven.notifier.Notifier;
import fr.jcgay.maven.notifier.Status;
import fr.jcgay.maven.notifier.sound.EndListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Notifier.class, hint="sound")
public class SoundNotifier
extends AbstractNotifier {
    @Override
    public void onFailWithoutProject(List<Throwable> exceptions) {
        this.playSound(Status.FAILURE);
    }

    @Override
    protected void fireNotification(MavenExecutionResult event) {
        this.playSound(this.getBuildStatus(event));
    }

    private void playSound(Status status) {
        try (AudioInputStream ais = this.getAudioStream(status);){
            if (ais == null) {
                this.logger.warn("Cannot get a sound to play. Skipping notification...");
                return;
            }
            this.play(ais);
        }
        catch (IOException | LineUnavailableException e) {
            this.fail(e);
        }
    }

    private void play(AudioInputStream ais) throws LineUnavailableException, IOException {
        try (Clip clip = AudioSystem.getClip();){
            EndListener listener = new EndListener();
            clip.addLineListener(listener);
            clip.open(ais);
            clip.start();
            this.wait(listener);
        }
    }

    private void wait(EndListener listener) {
        try {
            listener.waitEnd();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void fail(Exception e) {
        this.logger.debug("Error playing sound.", (Throwable)e);
    }

    private AudioInputStream getAudioStream(Status success) {
        try {
            return AudioSystem.getAudioInputStream(this.getUrl(success));
        }
        catch (IOException | UnsupportedAudioFileException e) {
            return this.noAudioStream(e);
        }
    }

    private AudioInputStream noAudioStream(Exception e) {
        this.logger.warn("Error reading audio stream.", (Throwable)e);
        return null;
    }

    private InputStream getUrl(Status status) {
        String sound = status == Status.SUCCESS ? "/109662__grunz__success.wav" : "/Sad_Trombone-Joe_Lamb-665429450.wav";
        return new BufferedInputStream(this.getClass().getResourceAsStream(sound));
    }
}

