/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification;

import com.google.auto.value.AutoValue;
import com.shaded.notifier.google.common.io.ByteStreams;
import fr.jcgay.notification.AutoValue_Icon;
import fr.jcgay.notification.SendNotificationException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

@AutoValue
public abstract class Icon {
    public abstract String id();

    public abstract URL content();

    public BufferedImage toImage() {
        try {
            return ImageIO.read(this.content());
        }
        catch (IOException e) {
            throw new SendNotificationException("Error while reading status icon.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toByteArray() {
        try (InputStream is = this.content().openStream();){
            byte[] byArray = ByteStreams.toByteArray(is);
            return byArray;
        }
        catch (IOException e) {
            throw new SendNotificationException("Error while reading status icon.", e);
        }
    }

    public String asPath() {
        String folder = System.getProperty("java.io.tmpdir") + "/send-notifications-icons/";
        String extension = this.extension();
        File icon = new File(folder + this.id() + "." + extension);
        if (!icon.exists()) {
            new File(folder).mkdirs();
            try {
                this.write(icon);
            }
            catch (IOException e) {
                throw new SendNotificationException("Can't write notification icon : " + icon.getPath(), e);
            }
        }
        return icon.getPath();
    }

    public String extension() {
        return this.content().getPath().substring(this.content().getPath().lastIndexOf(".") + 1);
    }

    public static Icon create(URL content, String id) {
        return new AutoValue_Icon(id, content);
    }

    private void write(File destination) throws IOException {
        try (InputStream input = this.content().openStream();
             FileOutputStream output = new FileOutputStream(destination);){
            int n;
            byte[] buffer = new byte[4096];
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
        }
    }
}

