/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification;

import com.shaded.notifier.google.common.annotations.VisibleForTesting;
import com.shaded.notifier.google.common.base.Preconditions;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Icon;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.NotifierProvider;
import fr.jcgay.notification.configuration.ChosenNotifiers;
import fr.jcgay.notification.configuration.ConfigurationReader;
import fr.jcgay.notification.configuration.OperatingSystem;
import fr.jcgay.notification.notifier.DoNothingNotifier;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendNotification {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendNotification.class);
    private final NotifierProvider provider;
    private ConfigurationReader configuration;
    private ChosenNotifiers chosenNotifiers;
    private Properties additionalConfiguration;
    private Application application = Application.builder().id("application/x-vnd-jcgay.send-notification-default").name("Send Notification (Default)").icon(Icon.create(SendNotification.class.getResource("/brochure5.png"), "send-notification")).build();

    SendNotification(ConfigurationReader configuration, OperatingSystem currentOs) {
        this(configuration, new NotifierProvider(currentOs));
    }

    SendNotification(ConfigurationReader configuration, NotifierProvider provider) {
        this.configuration = configuration;
        this.provider = provider;
    }

    public SendNotification() {
        this(ConfigurationReader.atPath(System.getProperty("user.home") + "/.send-notification"), new OperatingSystem());
    }

    @VisibleForTesting
    DiscoverableNotifier chooseNotifier() {
        Properties properties = this.configuration.get();
        this.mergeConfigurations(properties);
        this.maySetNotifierFromPropertyConfiguration(properties);
        if (this.chosenNotifiers != null) {
            LOGGER.debug("Notifications will be send to: {} for application: {}.", (Object)this.chosenNotifiers, (Object)this.application);
            return this.provider.byName(this.chosenNotifiers, properties, this.application);
        }
        return this.defaultNotifier(properties);
    }

    public Notifier initNotifier() {
        return this.chooseNotifier().init();
    }

    public SendNotification setApplication(Application application) {
        this.application = Preconditions.checkNotNull(application);
        return this;
    }

    public SendNotification setChosenNotifier(String chosenNotifier) {
        this.chosenNotifiers = ChosenNotifiers.from(chosenNotifier);
        return this;
    }

    public SendNotification setConfigurationPath(String configurationPath) {
        this.configuration = ConfigurationReader.atPath(configurationPath);
        return this;
    }

    public SendNotification addConfigurationProperties(Properties additionalConfiguration) {
        this.additionalConfiguration = additionalConfiguration;
        return this;
    }

    private DiscoverableNotifier defaultNotifier(Properties properties) {
        Set<DiscoverableNotifier> all = this.provider.available(properties, this.application);
        for (DiscoverableNotifier candidate : all) {
            boolean isAvailable = candidate.tryInit();
            LOGGER.debug("{} is available ? {}.", (Object)candidate, (Object)isAvailable);
            if (!isAvailable) continue;
            return candidate;
        }
        return DoNothingNotifier.doNothing();
    }

    private void mergeConfigurations(Properties properties) {
        if (this.additionalConfiguration != null && !this.additionalConfiguration.isEmpty()) {
            LOGGER.debug("Overriding previous configuration with: {}.", (Object)this.additionalConfiguration);
            properties.putAll((Map<?, ?>)this.additionalConfiguration);
        }
    }

    private void maySetNotifierFromPropertyConfiguration(Properties properties) {
        String candidate = (String)properties.get("notifier.implementation");
        if (this.chosenNotifiers == null && candidate != null) {
            this.chosenNotifiers = ChosenNotifiers.from(candidate);
        }
    }
}

