/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.configuration;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationReader.class);
    private final Properties properties;
    private final URL location;

    private ConfigurationReader(Properties properties) {
        this(properties, null);
    }

    public ConfigurationReader(Properties configuration, URL location) {
        this.properties = configuration;
        this.location = location;
    }

    public static ConfigurationReader atPath(String path) {
        try {
            return ConfigurationReader.atUrl(new File(path).toURI().toURL());
        }
        catch (MalformedURLException e) {
            LOGGER.debug("URL built for path [{}] is malformed will use default configuration.", (Object)path, (Object)e);
            return new ConfigurationReader(new Properties());
        }
    }

    public static ConfigurationReader atUrl(URL url) {
        Properties configuration = new Properties();
        try {
            configuration.load(url.openStream());
        }
        catch (IOException e) {
            LOGGER.debug("Cannot read configuration at [{}], will use default one.", (Object)url, (Object)e);
        }
        return new ConfigurationReader(configuration, url);
    }

    public Properties get() {
        LOGGER.debug("Notification configuration read from {} is: {}.", (Object)this.location, (Object)this.properties);
        return this.properties;
    }
}

