/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.additional;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import com.shaded.notifier.google.common.base.Preconditions;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.MultipleSendNotificationException;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditionalNotifier.class);
    private final Set<DiscoverableNotifier> secondary;
    private final DiscoverableNotifier primary;
    private final boolean notifyWithSecondaryNotifiers;

    public AdditionalNotifier(DiscoverableNotifier primary, Set<DiscoverableNotifier> secondary) {
        Preconditions.checkArgument(!secondary.isEmpty());
        this.primary = Preconditions.checkNotNull(primary);
        this.secondary = secondary;
        this.notifyWithSecondaryNotifiers = Boolean.valueOf(System.getProperty("notifyAll"));
    }

    @Override
    public Notifier init() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        AdditionalNotifier.safeInit(this.primary, errors);
        if (this.notifyWithSecondaryNotifiers) {
            for (DiscoverableNotifier notifier : this.secondary) {
                AdditionalNotifier.safeInit(notifier, errors);
            }
        }
        AdditionalNotifier.failIfNotEmpty(errors);
        return this;
    }

    @Override
    public boolean tryInit() {
        return false;
    }

    @Override
    public void send(Notification notification) {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        AdditionalNotifier.safeSend(this.primary, notification, errors);
        if (this.notifyWithSecondaryNotifiers) {
            for (DiscoverableNotifier notifier : this.secondary) {
                AdditionalNotifier.safeSend(notifier, notification, errors);
            }
        }
        AdditionalNotifier.failIfNotEmpty(errors);
    }

    @Override
    public void close() {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        AdditionalNotifier.safeClose(this.primary, errors);
        if (this.notifyWithSecondaryNotifiers) {
            for (DiscoverableNotifier notifier : this.secondary) {
                AdditionalNotifier.safeClose(notifier, errors);
            }
        }
        AdditionalNotifier.failIfNotEmpty(errors);
    }

    @Override
    public boolean isPersistent() {
        if (this.notifyWithSecondaryNotifiers) {
            boolean result = this.primary.isPersistent();
            for (DiscoverableNotifier notifier : this.secondary) {
                result |= notifier.isPersistent();
            }
            return result;
        }
        return this.primary.isPersistent();
    }

    public static void safeClose(DiscoverableNotifier notifier, List<Exception> errors) {
        try {
            notifier.close();
        }
        catch (RuntimeException e) {
            LOGGER.debug("Error closing {}.", (Object)notifier, (Object)e);
            errors.add(e);
        }
    }

    private static void failIfNotEmpty(List<Exception> errors) {
        if (!errors.isEmpty()) {
            throw new MultipleSendNotificationException(errors);
        }
    }

    private static void safeSend(DiscoverableNotifier notifier, Notification notification, List<Exception> errors) {
        try {
            notifier.send(notification);
        }
        catch (RuntimeException e) {
            LOGGER.debug("Error sending notification {} with {}.", new Object[]{notification, notifier, e});
            errors.add(e);
        }
    }

    public static void safeInit(DiscoverableNotifier notifier, List<Exception> errors) {
        try {
            notifier.init();
        }
        catch (RuntimeException e) {
            LOGGER.debug("Error initializing {}.", (Object)notifier, (Object)e);
            errors.add(e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.secondary, this.primary, this.notifyWithSecondaryNotifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AdditionalNotifier other = (AdditionalNotifier)obj;
        return Objects.equal(this.secondary, other.secondary) && Objects.equal(this.primary, other.primary) && Objects.equal(this.notifyWithSecondaryNotifiers, other.notifyWithSecondaryNotifiers);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("secondary", this.secondary).add("primary", this.primary).add("notifyWithSecondaryNotifiers", this.notifyWithSecondaryNotifiers).toString();
    }
}

