/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.anybar;

import com.shaded.notifier.google.common.annotations.VisibleForTesting;
import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Icon;
import fr.jcgay.notification.IconFileWriter;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.anybar.AnyBarConfiguration;
import fr.jcgay.notification.notifier.anybar.AnyBarException;
import fr.jcgay.notification.notifier.anybar.AnyBarIconWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyBarNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnyBarNotifier.class);
    private final Application application;
    private final AnyBarConfiguration configuration;
    private final IconFileWriter iconWriter;
    private final DatagramSocket socket;
    private boolean isInitialized;

    @VisibleForTesting
    AnyBarNotifier(Application application, AnyBarConfiguration configuration, DatagramSocket socket, IconFileWriter iconWriter) {
        LOGGER.debug("Configuring AnyBar for application {}: {}.", (Object)application, (Object)configuration);
        this.socket = socket;
        this.iconWriter = iconWriter;
        this.application = application;
        this.configuration = configuration;
    }

    public static AnyBarNotifier create(Application application, AnyBarConfiguration configuration) {
        try {
            return new AnyBarNotifier(application, configuration, new DatagramSocket(), new AnyBarIconWriter());
        }
        catch (SocketException e) {
            throw new AnyBarException("Error while initiating connection with AnyBar", e);
        }
    }

    @Override
    public Notifier init() {
        if (this.isInitialized) {
            return this;
        }
        try {
            if (this.application.timeout() > 0L) {
                this.socket.setSoTimeout((int)this.application.timeout());
            }
        }
        catch (IOException e) {
            throw new AnyBarException("Error while setting socket timeout", e);
        }
        this.changeIcon(this.application.icon());
        this.isInitialized = true;
        return this;
    }

    @Override
    public void send(Notification notification) {
        this.changeIcon(notification.icon());
    }

    @Override
    public void close() {
        this.socket.close();
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean tryInit() {
        return false;
    }

    private void changeIcon(Icon icon) {
        this.iconWriter.write(icon);
        byte[] data = icon.id().getBytes();
        try {
            this.socket.send(new DatagramPacket(data, data.length, InetAddress.getByName(this.configuration.host()), this.configuration.port()));
        }
        catch (IOException e) {
            throw new AnyBarException("Error while changing AnyBar icon", e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnyBarNotifier other = (AnyBarNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("configuration", this.configuration).add("application", this.application).toString();
    }
}

