/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.burnttoast;

import com.profesorfalken.jpowershell.PowerShell;
import com.profesorfalken.jpowershell.PowerShellResponse;
import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.burnttoast.BurntToastException;
import fr.jcgay.notification.notifier.burnttoast.BurntToastNotifierConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BurntToastNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(BurntToastNotifier.class);
    private final Application application;
    private final BurntToastNotifierConfiguration configuration;

    public BurntToastNotifier(Application application, BurntToastNotifierConfiguration configuration) {
        this.application = application;
        this.configuration = configuration;
    }

    @Override
    public void send(Notification notification) {
        StringBuilder command = new StringBuilder().append("New-BurntToastNotification -Text '").append(notification.title()).append("', '").append(notification.message()).append("' -AppLogo ").append(notification.icon().asPath());
        if (this.configuration.sound() == null) {
            command.append(" -Silent");
        } else {
            command.append(" -Sound ").append(this.configuration.sound());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will execute PowerShell: {}", (Object)command.toString());
        }
        PowerShellResponse response = PowerShell.executeSingleCommand(command.toString());
        LOGGER.debug("Response: {}", (Object)response.getCommandOutput());
        if (response.isError()) {
            throw new BurntToastException(response.getCommandOutput());
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public Notifier init() {
        return this;
    }

    @Override
    public boolean tryInit() {
        PowerShellResponse response = PowerShell.executeSingleCommand("Get-Module -ListAvailable -Name BurntToast | Format-Table Name");
        return !response.isError() && response.getCommandOutput().toLowerCase().contains("burnttoast");
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BurntToastNotifier other = (BurntToastNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("application", this.application).add("configuration", this.configuration).toString();
    }
}

