/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.executor;

import com.shaded.notifier.google.common.base.Joiner;
import com.shaded.notifier.google.common.base.Throwables;
import fr.jcgay.notification.SendNotificationException;
import fr.jcgay.notification.notifier.executor.Executor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeExecutor
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeExecutor.class);
    private static final int DEFAULT_WAIT_PROCESS_TIMEOUT = 500;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final long timeout;

    public RuntimeExecutor(long timeout) {
        this.timeout = timeout == -1L ? 500L : timeout;
    }

    @Override
    public void exec(String[] command) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Will execute command line: {} (waiting at most: {} milliseconds)", (Object)RuntimeExecutor.logCommand(command), (Object)this.timeout);
        }
        Future<Integer> task = this.executor.submit(() -> {
            try {
                Process execution = new ProcessBuilder(command).redirectErrorStream(true).start();
                int returnCode = execution.waitFor();
                if (returnCode != 0) {
                    String message = "Command <[" + RuntimeExecutor.logCommand(command) + "]> returns code: " + returnCode + ".\n" + RuntimeExecutor.asString(execution.getInputStream());
                    LOGGER.debug(message);
                    throw new SendNotificationException(message);
                }
                LOGGER.debug("Command <[{}]> ends successfully.", (Object)RuntimeExecutor.logCommand(command));
                return returnCode;
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate(e);
            }
        });
        try {
            task.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate(e);
        }
        catch (ExecutionException e) {
            LOGGER.debug("An error occurs while running command: <[{}]>", (Object)RuntimeExecutor.logCommand(command), (Object)e);
            throw Throwables.propagate(e.getCause());
        }
        catch (TimeoutException e) {
            LOGGER.debug("Command <[{}]> takes too long to execute. Do not wait for the result...", (Object)RuntimeExecutor.logCommand(command), (Object)e);
        }
    }

    @Override
    public boolean tryExec(String[] command) {
        try {
            this.exec(command);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static String logCommand(String[] command) {
        return Joiner.on(" ").join(command);
    }

    private static String asString(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            StringBuilder output = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            String string = output.toString();
            return string;
        }
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

