/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.growl;

import com.google.code.jgntp.Gntp;
import com.google.code.jgntp.GntpApplicationInfo;
import com.google.code.jgntp.GntpClient;
import com.google.code.jgntp.GntpNotification;
import com.google.code.jgntp.GntpNotificationInfo;
import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.growl.GntpSlf4jListener;
import fr.jcgay.notification.notifier.growl.GrowlConfiguration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrowlNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrowlNotifier.class);
    private final Application application;
    private final GrowlConfiguration configuration;
    private final GntpSlf4jListener logListener;
    private GntpNotificationInfo gNotification;
    private GntpClient gClient;

    public GrowlNotifier(Application application, GrowlConfiguration configuration, GntpSlf4jListener logListener) {
        LOGGER.debug("Configuring Growl for application {}: {}.", (Object)application, (Object)configuration);
        this.application = application;
        this.configuration = configuration;
        this.logListener = logListener;
    }

    @Override
    public Notifier init() {
        if (this.isClientRegistered()) {
            return this;
        }
        GntpApplicationInfo gApplication = Gntp.appInfo(this.application.name()).build();
        this.gNotification = Gntp.notificationInfo(gApplication, this.application.id()).icon(this.application.icon().toImage()).build();
        Gntp clientBuilder = Gntp.client(gApplication).onPort(this.configuration.port()).forHost(this.configuration.host()).withoutRetry().listener(this.logListener);
        if (this.configuration.password() != null) {
            clientBuilder.withPassword(this.configuration.password());
        }
        this.gClient = clientBuilder.build();
        this.gClient.register();
        try {
            this.gClient.waitRegistration(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    @Override
    public void send(Notification notification) {
        if (this.isClientRegistered()) {
            GntpNotification success = Gntp.notification(this.gNotification, notification.title()).text(notification.message()).icon(notification.icon().toImage()).priority(GrowlNotifier.toPriority(notification.level())).build();
            try {
                this.gClient.notify(success, 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void close() {
        if (this.isClientRegistered()) {
            try {
                TimeUnit.SECONDS.sleep(1L);
                this.gClient.shutdown(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        this.init();
        boolean hasSucceeded = this.isClientRegistered();
        if (!hasSucceeded) {
            try {
                this.gClient.shutdown(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return hasSucceeded;
    }

    private static GntpNotification.Priority toPriority(Notification.Level level) {
        switch (level) {
            case INFO: {
                return GntpNotification.Priority.NORMAL;
            }
            case WARNING: {
                return GntpNotification.Priority.HIGH;
            }
            case ERROR: {
                return GntpNotification.Priority.HIGHEST;
            }
        }
        return GntpNotification.Priority.NORMAL;
    }

    private boolean isClientRegistered() {
        return this.gClient != null && this.gClient.isRegistered();
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration, this.logListener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GrowlNotifier other = (GrowlNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration) && Objects.equal(this.logListener, other.logListener);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("application", this.application).add("configuration", this.configuration).add("logListener", this.logListener).toString();
    }
}

