/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.kdialog;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.executor.Executor;
import fr.jcgay.notification.notifier.kdialog.KdialogConfiguration;
import fr.jcgay.notification.notifier.kdialog.KdialogException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdialogNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(KdialogNotifier.class);
    private final Application application;
    private final KdialogConfiguration configuration;
    private final Executor executor;

    public KdialogNotifier(Application application, KdialogConfiguration configuration, Executor executor) {
        LOGGER.debug("Configuring Kdialog for application {}: {}.", (Object)application, (Object)configuration);
        this.application = application;
        this.configuration = configuration;
        this.executor = executor;
    }

    @Override
    public Notifier init() {
        return this;
    }

    @Override
    public void send(Notification notification) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add("--passivepopup");
        commands.add(notification.message());
        if (this.application.timeout() != -1L) {
            commands.add(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(this.application.timeout())));
        }
        commands.add("--title");
        commands.add(notification.title());
        commands.add("--icon");
        commands.add(notification.icon().asPath());
        try {
            this.executor.exec(commands.toArray(new String[0]));
        }
        catch (RuntimeException e) {
            throw new KdialogException("Error while sending notification with Kdialog.", e);
        }
    }

    @Override
    public void close() {
        this.executor.close();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add("-v");
        return this.executor.tryExec(commands.toArray(new String[0]));
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KdialogNotifier other = (KdialogNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("configuration", this.configuration).add("application", this.application).toString();
    }
}

