/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.notificationcenter;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.executor.Executor;
import fr.jcgay.notification.notifier.notificationcenter.SimpleNotificationCenterException;
import fr.jcgay.notification.notifier.notificationcenter.TerminalNotifierConfiguration;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleNotificationCenterNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleNotificationCenterNotifier.class);
    private static final String DOUBLE_QUOTE = "\"";
    private final TerminalNotifierConfiguration configuration;
    private final Executor executor;

    public SimpleNotificationCenterNotifier(TerminalNotifierConfiguration configuration, Executor executor) {
        LOGGER.debug("Configuring notification-center : {}.", (Object)configuration);
        this.configuration = configuration;
        this.executor = executor;
    }

    @Override
    public Notifier init() {
        return this;
    }

    @Override
    public void send(Notification notification) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("osascript");
        commands.add("-e");
        commands.add(this.buildAppleScript(notification));
        try {
            this.executor.exec(commands.toArray(new String[0]));
        }
        catch (RuntimeException e) {
            throw new SimpleNotificationCenterException("Error while sending notification to terminal-notifier", e.getCause());
        }
    }

    private String buildAppleScript(Notification notification) {
        StringBuilder script = new StringBuilder("display notification ");
        script.append(DOUBLE_QUOTE).append(notification.message()).append(DOUBLE_QUOTE);
        if (this.configuration.sound() != null) {
            script.append(" sound name ").append(DOUBLE_QUOTE).append(this.configuration.sound()).append(DOUBLE_QUOTE);
        }
        script.append(" with title ").append(DOUBLE_QUOTE).append(notification.title()).append(DOUBLE_QUOTE);
        if (notification.subtitle() != null) {
            script.append(" subtitle ").append(DOUBLE_QUOTE).append(notification.subtitle()).append(DOUBLE_QUOTE);
        }
        return script.toString();
    }

    @Override
    public void close() {
        this.executor.close();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleNotificationCenterNotifier other = (SimpleNotificationCenterNotifier)obj;
        return Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("configuration", this.configuration).toString();
    }
}

