/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.notificationcenter;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.executor.Executor;
import fr.jcgay.notification.notifier.notificationcenter.TerminalNotifierConfiguration;
import fr.jcgay.notification.notifier.notificationcenter.TerminalNotifierNotificationException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalNotifier.class);
    private final Application application;
    private final TerminalNotifierConfiguration configuration;
    private final Executor executor;

    public TerminalNotifier(Application application, TerminalNotifierConfiguration configuration, Executor executor) {
        LOGGER.debug("Configuring terminal-notifier for application {}: {}.", (Object)application, (Object)configuration);
        this.application = application;
        this.configuration = configuration;
        this.executor = executor;
    }

    @Override
    public Notifier init() {
        return this;
    }

    @Override
    public void send(Notification notification) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add("-title");
        commands.add(this.application.name());
        if (notification.subtitle() != null) {
            commands.add("-subtitle");
            commands.add(notification.subtitle());
        }
        commands.add("-message");
        commands.add(notification.message());
        commands.add("-group");
        commands.add(this.application.id());
        if (this.configuration.activateApplication() != null) {
            commands.add("-activate");
            commands.add(this.configuration.activateApplication());
        }
        commands.add("-contentImage");
        commands.add(notification.icon().asPath());
        if (this.configuration.sound() != null) {
            commands.add("-sound");
            commands.add(this.configuration.sound());
        }
        commands.add("-appIcon");
        commands.add(this.application.icon().asPath());
        try {
            this.executor.exec(commands.toArray(new String[0]));
        }
        catch (RuntimeException e) {
            throw new TerminalNotifierNotificationException("Error while sending notification to terminal-notifier", e);
        }
    }

    @Override
    public void close() {
        this.executor.close();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add("-help");
        return this.executor.tryExec(commands.toArray(new String[0]));
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TerminalNotifier other = (TerminalNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("application", this.application).add("configuration", this.configuration).toString();
    }
}

