/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.notifu;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.executor.Executor;
import fr.jcgay.notification.notifier.notifu.NotifuConfiguration;
import fr.jcgay.notification.notifier.notifu.NotifuException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifuNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifuNotifier.class);
    private final Application application;
    private final NotifuConfiguration configuration;
    private final Executor executor;

    public NotifuNotifier(Application application, NotifuConfiguration configuration, Executor executor) {
        LOGGER.debug("Configuring notifu for application {}: {}.", (Object)application, (Object)configuration);
        this.application = application;
        this.configuration = configuration;
        this.executor = executor;
    }

    @Override
    public Notifier init() {
        return this;
    }

    @Override
    public void send(Notification notification) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add("/p");
        commands.add(NotifuNotifier.escape(notification.title()));
        commands.add("/m");
        commands.add(NotifuNotifier.escape(notification.message()));
        commands.add("/d");
        if (this.application.timeout() == -1L) {
            commands.add(String.valueOf(TimeUnit.SECONDS.toMillis(10L)));
        } else {
            commands.add(String.valueOf(this.application.timeout()));
        }
        commands.add("/t");
        commands.add(NotifuNotifier.toType(notification.level()));
        commands.add("/q");
        try {
            this.executor.exec(commands.toArray(new String[0]));
        }
        catch (RuntimeException e) {
            throw new NotifuException("Error while sending notification to notifu.", e.getCause());
        }
    }

    private static String escape(String title) {
        return title.replace("\"", "\\\"");
    }

    private static String toType(Notification.Level level) {
        switch (level) {
            case WARNING: {
                return "warn";
            }
            case ERROR: {
                return "error";
            }
        }
        return "info";
    }

    @Override
    public void close() {
        this.executor.close();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add("/v");
        return this.executor.tryExec(commands.toArray(new String[0]));
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NotifuNotifier other = (NotifuNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("configuration", this.configuration).add("application", this.application).toString();
    }
}

