/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.notify;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import dorkbox.notify.Notify;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.notify.NotifyConfiguration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyNotifier.class);
    private final Application application;
    private final NotifyConfiguration configuration;
    private boolean skipNotifications;

    public NotifyNotifier(Application application, NotifyConfiguration configuration) {
        LOGGER.debug("Configuring notify: {}.", (Object)configuration);
        this.configuration = configuration;
        this.application = application;
    }

    @Override
    public Notifier init() {
        if (NotifyNotifier.isHeadless()) {
            this.skipNotifications = true;
        }
        return this;
    }

    @Override
    public boolean tryInit() {
        this.init();
        return !this.skipNotifications;
    }

    @Override
    public void send(Notification notification) {
        Notify notify = Notify.create().title(notification.title()).text(notification.message()).image(notification.icon().toImage()).position(this.configuration.position()).hideAfter((int)(this.application.timeout() == -1L ? TimeUnit.SECONDS.toMillis(3L) : this.application.timeout()));
        if (this.configuration.withDarkStyle()) {
            notify.darkStyle();
        }
        notify.show();
    }

    @Override
    public void close() {
        if (!this.skipNotifications) {
            try {
                Thread.sleep(this.application.timeout() == -1L ? TimeUnit.SECONDS.toMillis(3L) : this.application.timeout());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean isHeadless() {
        return "true".equals(System.getProperty("java.awt.headless"));
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration, this.skipNotifications);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NotifyNotifier other = (NotifyNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration) && Objects.equal(this.skipNotifications, other.skipNotifications);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("application", this.application).add("configuration", this.configuration).add("skipNotifications", this.skipNotifications).toString();
    }
}

