/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.notifysend;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.executor.Executor;
import fr.jcgay.notification.notifier.notifysend.NotifySendConfiguration;
import fr.jcgay.notification.notifier.notifysend.NotifySendNotificationException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifySendNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifySendNotifier.class);
    private static final String CMD_TIMEOUT = "-t";
    private static final String CMD_ICON = "-i";
    private static final String CMD_URGENCY = "-u";
    private final Application application;
    private final NotifySendConfiguration configuration;
    private final Executor executor;

    public NotifySendNotifier(Application application, NotifySendConfiguration configuration, Executor executor) {
        LOGGER.debug("Configuring notify-send for application {}: {}.", (Object)application, (Object)configuration);
        this.application = application;
        this.configuration = configuration;
        this.executor = executor;
    }

    @Override
    public Notifier init() {
        return this;
    }

    @Override
    public void send(Notification notification) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add(notification.title());
        commands.add(notification.message());
        if (this.application.timeout() != -1L) {
            commands.add(CMD_TIMEOUT);
            commands.add(String.valueOf(this.application.timeout()));
        }
        commands.add(CMD_ICON);
        commands.add(notification.icon().asPath());
        commands.add(CMD_URGENCY);
        commands.add(NotifySendNotifier.toUrgency(notification.level()));
        try {
            this.executor.exec(commands.toArray(new String[0]));
        }
        catch (RuntimeException e) {
            throw new NotifySendNotificationException("Error while sending notification to notify-send.", e.getCause());
        }
    }

    @Override
    public void close() {
        this.executor.close();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add("-v");
        return this.executor.tryExec(commands.toArray(new String[0]));
    }

    private static String toUrgency(Notification.Level level) {
        switch (level) {
            case WARNING: 
            case ERROR: {
                return "critical";
            }
        }
        return "normal";
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NotifySendNotifier other = (NotifySendNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("application", this.application).add("configuration", this.configuration).toString();
    }
}

