/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.pushbullet;

import com.squareup.mimecraft.FormEncoding;
import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.pushbullet.PushbulletConfiguration;
import fr.jcgay.notification.notifier.pushbullet.PushbulletNotificationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushbulletNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushbulletNotifier.class);
    private final PushbulletConfiguration configuration;
    private final String url;
    private OkHttpClient client;

    public PushbulletNotifier(Application application, PushbulletConfiguration configuration) {
        this(application, configuration, "https://api.pushbullet.com/v2/pushes");
    }

    PushbulletNotifier(Application application, PushbulletConfiguration configuration, String url) {
        LOGGER.debug("Configuring Pushbullet for application {}: {}.", (Object)application, (Object)configuration);
        this.configuration = configuration;
        this.url = url;
    }

    @Override
    public Notifier init() {
        if (this.client != null) {
            return this;
        }
        this.client = new OkHttpClient();
        this.client.setAuthenticator(new Authenticator(){

            @Override
            public Request authenticate(Proxy proxy, Response response) {
                String credentials = Credentials.basic(PushbulletNotifier.this.configuration.key(), "");
                if (credentials.equals(response.request().header("Authorization"))) {
                    return null;
                }
                return response.request().newBuilder().header("Authorization", credentials).build();
            }

            @Override
            public Request authenticateProxy(Proxy proxy, Response response) {
                return this.authenticate(proxy, response);
            }
        });
        return this;
    }

    @Override
    public void send(Notification notification) {
        Request request = new Request.Builder().url(this.url).post(this.buildRequestBody(notification)).build();
        try {
            Response response = this.client.newCall(request).execute();
            if (response.code() != 200) {
                String message = String.format("Pushbullet notification has failed, [%s] - [%s]%n%s", response.code(), response.message(), response.body().string());
                LOGGER.error(message);
                throw new PushbulletNotificationException(message);
            }
        }
        catch (IOException e) {
            String message = "Error while sending pushbullet notification.";
            LOGGER.error(message, (Throwable)e);
            throw new PushbulletNotificationException(message, e);
        }
    }

    private RequestBody buildRequestBody(Notification notification) {
        ByteArrayOutputStream data;
        FormEncoding.Builder builder = new FormEncoding.Builder();
        if (this.configuration.device() != null) {
            builder.add("device_iden", this.configuration.device());
        }
        if (this.configuration.email() != null) {
            builder.add("email", this.configuration.email());
        }
        builder.add("type", "note").add("title", notification.title()).add("body", notification.message());
        try {
            data = new ByteArrayOutputStream();
            builder.build().writeBodyTo(data);
        }
        catch (IOException e) {
            String message = "Can't build request body.";
            LOGGER.error(message, (Throwable)e);
            throw new PushbulletNotificationException(message, e);
        }
        return RequestBody.create(MediaType.parse("application/x-www-form-urlencoded"), data.toByteArray());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        return false;
    }
}

