/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.slack;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.slack.SlackConfiguration;
import fr.jcgay.notification.notifier.slack.SlackNotificationException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackNotifier.class);
    private final Application application;
    private final SlackConfiguration configuration;
    private final String url;
    private OkHttpClient client;

    public SlackNotifier(Application application, SlackConfiguration configuration, String url) {
        LOGGER.debug("Configuring Slack for application {}: {}.", (Object)application, (Object)configuration);
        this.application = application;
        this.configuration = configuration;
        this.url = url;
    }

    public SlackNotifier(Application application, SlackConfiguration configuration) {
        this(application, configuration, "https://slack.com/api/chat.postMessage");
    }

    @Override
    public Notifier init() {
        if (this.client != null) {
            return this;
        }
        this.client = new OkHttpClient();
        return this;
    }

    @Override
    public boolean tryInit() {
        return false;
    }

    @Override
    public void send(Notification notification) {
        StringBuilder builder = new StringBuilder(this.url).append("?token=").append(this.configuration.token()).append("&channel=").append(SlackNotifier.encode(this.configuration.channel())).append("&attachments=").append(SlackNotifier.encode(this.attachments(notification)));
        try {
            String requestUrl = builder.toString();
            LOGGER.debug("Calling Slack with parameters: {}", (Object)requestUrl);
            Response response = this.client.newCall(new Request.Builder().url(requestUrl).get().build()).execute();
            if (response.code() != 200) {
                String message = String.format("Slack notification has failed, [%s] - [%s]%n%s", response.code(), response.message(), response.body().string());
                LOGGER.error(message);
                throw new SlackNotificationException(message);
            }
        }
        catch (IOException e) {
            String message = "Error while sending Slack notification.";
            LOGGER.error(message, (Throwable)e);
            throw new SlackNotificationException(message, e);
        }
    }

    private String attachments(Notification notification) {
        return "[{\"fallback\":\"" + notification.message() + "\",\"color\":\"" + SlackNotifier.colorize(notification) + "\",\"author_name\":\"" + this.application.name() + "\",\"title\":\"" + notification.title() + "\",\"text\":\"" + notification.message() + "\n" + notification.subtitle() + "\",}]";
    }

    private static String colorize(Notification notification) {
        switch (notification.level()) {
            case INFO: {
                return "good";
            }
            case WARNING: {
                return "warning";
            }
            case ERROR: {
                return "danger";
            }
        }
        return "warning";
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SlackNotificationException("Cannot encode URL parameter: " + string, e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isPersistent() {
        return false;
    }
}

