/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.snarl;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import com.shaded.notifier.google.common.io.Closeables;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.snarl.SnarlConfiguration;
import fr.jcgay.notification.notifier.snarl.SnarlNotificationException;
import fr.jcgay.snp4j.Icon;
import fr.jcgay.snp4j.Server;
import fr.jcgay.snp4j.SnpException;
import fr.jcgay.snp4j.impl.SnpNotifier;
import fr.jcgay.snp4j.request.Priority;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnarlNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnarlNotifier.class);
    private final Application application;
    private final SnarlConfiguration configuration;
    private final fr.jcgay.snp4j.Application snarlApplication;
    private fr.jcgay.snp4j.Notifier snarl;

    public SnarlNotifier(Application application, SnarlConfiguration configuration) {
        LOGGER.debug("Configuring Snarl for application {}: {}.", (Object)application, (Object)configuration);
        this.application = application;
        this.configuration = configuration;
        this.snarlApplication = fr.jcgay.snp4j.Application.withPassword(application.id(), application.name(), configuration.applicationPassword());
    }

    @Override
    public Notifier init() {
        Server server = Server.builder().withHost(this.configuration.host()).withPort(this.configuration.port()).build();
        try {
            this.snarl = SnpNotifier.of(this.snarlApplication, server);
        }
        catch (SnpException e) {
            throw new SnarlNotificationException("Cannot register application with Snarl.", e);
        }
        return this;
    }

    @Override
    public void send(Notification notification) {
        if (this.snarl == null) {
            LOGGER.warn("Snarl notifier is not initialized, cannot send notification.");
            return;
        }
        fr.jcgay.snp4j.request.Notification snarlNotification = new fr.jcgay.snp4j.request.Notification();
        snarlNotification.setIcon(Icon.base64(notification.icon().toByteArray()));
        snarlNotification.setText(notification.message());
        snarlNotification.setTitle(notification.title());
        snarlNotification.setPriority(SnarlNotifier.toPriority(notification.level()));
        this.init();
        try {
            this.snarl.send(snarlNotification);
        }
        catch (SnpException e) {
            throw new SnarlNotificationException("Cannot send notification to Snarl.", e);
        }
    }

    @Override
    public void close() {
        if (this.snarl != null) {
            try {
                Closeables.close(this.snarl, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        try {
            this.init();
            return true;
        }
        catch (RuntimeException e) {
            this.close();
            return false;
        }
    }

    private static Priority toPriority(Notification.Level level) {
        switch (level) {
            case WARNING: 
            case ERROR: {
                return Priority.HIGH;
            }
        }
        return Priority.NORMAL;
    }

    public int hashCode() {
        return Objects.hashCode(this.application, this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SnarlNotifier other = (SnarlNotifier)obj;
        return Objects.equal(this.application, other.application) && Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("application", this.application).add("configuration", this.configuration).toString();
    }
}

