/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.systemtray;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.Application;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.systemtray.SystemTrayNotificationException;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTrayNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemTrayNotifier.class);
    private final Application application;
    private boolean skipNotifications;
    private TrayIcon icon;

    public SystemTrayNotifier(Application application) {
        LOGGER.debug("Configuring System Tray for application {}.", (Object)application);
        this.application = application;
    }

    @Override
    public Notifier init() {
        if (this.icon != null) {
            return this;
        }
        if (!SystemTray.isSupported()) {
            this.skipNotifications = true;
            LOGGER.warn("SystemTray is not supported, skipping notifications...");
            return this;
        }
        this.icon = new TrayIcon(this.createImage(this.application.icon().toByteArray()), this.application.name());
        this.icon.setImageAutoSize(true);
        try {
            SystemTray.getSystemTray().add(this.icon);
        }
        catch (AWTException e) {
            throw new SystemTrayNotificationException("Error initializing SystemTray Icon.", e);
        }
        return this;
    }

    @Override
    public void send(Notification notification) {
        if (!this.skipNotifications) {
            this.icon.setImage(this.createImage(notification.icon().toByteArray()));
            this.icon.displayMessage(notification.title(), notification.message(), SystemTrayNotifier.toMessageType(notification.level()));
        }
    }

    @Override
    public void close() {
        if (!this.skipNotifications) {
            try {
                Thread.sleep(this.application.timeout() == -1L ? TimeUnit.SECONDS.toMillis(2L) : this.application.timeout());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            SystemTray.getSystemTray().remove(this.icon);
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean tryInit() {
        this.init();
        return !this.skipNotifications;
    }

    private static TrayIcon.MessageType toMessageType(Notification.Level level) {
        switch (level) {
            case INFO: {
                return TrayIcon.MessageType.INFO;
            }
            case WARNING: {
                return TrayIcon.MessageType.WARNING;
            }
            case ERROR: {
                return TrayIcon.MessageType.ERROR;
            }
        }
        return TrayIcon.MessageType.NONE;
    }

    private Image createImage(byte[] imageData) {
        return Toolkit.getDefaultToolkit().createImage(imageData);
    }

    public int hashCode() {
        return Objects.hashCode(this.application);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemTrayNotifier other = (SystemTrayNotifier)obj;
        return Objects.equal(this.application, other.application);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("application", this.application).toString();
    }
}

