/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.notification.notifier.toaster;

import com.shaded.notifier.google.common.base.MoreObjects;
import com.shaded.notifier.google.common.base.Objects;
import fr.jcgay.notification.DiscoverableNotifier;
import fr.jcgay.notification.Notification;
import fr.jcgay.notification.Notifier;
import fr.jcgay.notification.notifier.executor.Executor;
import fr.jcgay.notification.notifier.toaster.ToasterConfiguration;
import fr.jcgay.notification.notifier.toaster.ToasterNotificationException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToasterNotifier
implements DiscoverableNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToasterNotifier.class);
    private static final String DOUBLE_QUOTE = "\"";
    private final ToasterConfiguration configuration;
    private final Executor executor;

    public ToasterNotifier(ToasterConfiguration configuration, Executor executor) {
        LOGGER.debug("Configuring toaster: {}.", (Object)configuration);
        this.configuration = configuration;
        this.executor = executor;
    }

    @Override
    public Notifier init() {
        return this;
    }

    @Override
    public void send(Notification notification) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        commands.add("-t");
        commands.add(DOUBLE_QUOTE + notification.title() + DOUBLE_QUOTE);
        commands.add("-m");
        commands.add(DOUBLE_QUOTE + notification.message() + DOUBLE_QUOTE);
        commands.add("-p");
        commands.add(DOUBLE_QUOTE + notification.icon().asPath() + DOUBLE_QUOTE);
        try {
            this.executor.exec(commands.toArray(new String[0]));
        }
        catch (RuntimeException e) {
            throw new ToasterNotificationException("Error while sending notification with toaster", e);
        }
    }

    @Override
    public void close() {
        this.executor.close();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean tryInit() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.bin());
        return this.executor.tryExec(commands.toArray(new String[0]));
    }

    public int hashCode() {
        return Objects.hashCode(this.configuration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ToasterNotifier other = (ToasterNotifier)obj;
        return Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("configuration", this.configuration).toString();
    }
}

