/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j;

import java.util.UUID;
import lombok.NonNull;

public class Application {
    @NonNull
    private final String appSig;
    @NonNull
    private final String title;
    private final String password;

    public static Application withPassword(@NonNull String appSig, @NonNull String title) {
        if (appSig == null) {
            throw new NullPointerException("appSig");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        return new Application(appSig, title, UUID.randomUUID().toString());
    }

    public static Application withoutPassword(@NonNull String appSig, @NonNull String title) {
        if (appSig == null) {
            throw new NullPointerException("appSig");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        return new Application(appSig, title, null);
    }

    private Application(@NonNull String appSig, @NonNull String title, String password) {
        if (appSig == null) {
            throw new NullPointerException("appSig");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.appSig = appSig;
        this.title = title;
        this.password = password;
    }

    public static Application withPassword(@NonNull String appSig, @NonNull String title, String password) {
        return new Application(appSig, title, password);
    }

    @NonNull
    public String getAppSig() {
        return this.appSig;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appSig = this.getAppSig();
        String other$appSig = other.getAppSig();
        if (this$appSig == null ? other$appSig != null : !this$appSig.equals(other$appSig)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Application;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appSig = this.getAppSig();
        result = result * 59 + ($appSig == null ? 43 : $appSig.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "Application(appSig=" + this.getAppSig() + ", title=" + this.getTitle() + ")";
    }
}

