/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j;

import java.net.URL;
import javax.xml.bind.DatatypeConverter;
import lombok.NonNull;

public class Icon {
    private final String value;
    private final boolean base64;

    @NonNull
    public static Icon path(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return new Icon(path, false);
    }

    @NonNull
    public static Icon url(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url");
        }
        return new Icon(url.toString(), false);
    }

    @NonNull
    public static Icon stock(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return new Icon("!" + name, false);
    }

    @NonNull
    public static Icon base64(byte[] bytes) {
        return new Icon(Icon.sanitize(DatatypeConverter.printBase64Binary((byte[])bytes)), true);
    }

    private static String sanitize(String string) {
        return string.replace('=', '%').replace("\r\n", "#");
    }

    public boolean isBase64() {
        return this.base64;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Icon)) {
            return false;
        }
        Icon other = (Icon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return this.isBase64() == other.isBase64();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Icon;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isBase64() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "Icon(value=" + this.getValue() + ", base64=" + this.isBase64() + ")";
    }

    private Icon(String value, boolean base64) {
        this.value = value;
        this.base64 = base64;
    }

    public String getValue() {
        return this.value;
    }
}

