/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j;

import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class Server {
    @NonNull
    private final String host;
    private final int port;
    private final long timeout;
    private final String password;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"host", "port", "timeout", "password"})
    public Server(@NonNull String host, int port, long timeout, String password) {
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.password = password;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        long $timeout = this.getTimeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "Server(host=" + this.getHost() + ", port=" + this.getPort() + ", timeout=" + this.getTimeout() + ")";
    }

    public static class Builder {
        private String host;
        private String password;
        private Integer port;
        private Long timeout;

        private Builder() {
        }

        public Builder withHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host");
            }
            this.host = host;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Server build() {
            return new Server(this.host != null ? this.host : "localhost", this.port != null ? this.port : 9887, this.timeout != null ? this.timeout.longValue() : TimeUnit.SECONDS.toMillis(1L), this.password);
        }
    }
}

