/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j.impl;

import fr.jcgay.snp4j.Application;
import fr.jcgay.snp4j.Notifier;
import fr.jcgay.snp4j.Server;
import fr.jcgay.snp4j.SnpException;
import fr.jcgay.snp4j.impl.SnpSocket;
import fr.jcgay.snp4j.impl.SnpSocketImpl;
import fr.jcgay.snp4j.impl.request.Action;
import fr.jcgay.snp4j.impl.request.Request;
import fr.jcgay.snp4j.impl.response.Response;
import fr.jcgay.snp4j.request.Notification;
import fr.jcgay.snp4j.response.NotificationResult;
import java.io.IOException;
import java.util.UUID;
import lombok.NonNull;

public class SnpNotifier
implements Notifier {
    private final Application application;
    private final SnpSocket socket;

    @Override
    public NotificationResult send(@NonNull Notification notification) {
        Request request;
        Response response;
        if (notification == null) {
            throw new NullPointerException("notification");
        }
        if (notification.getIcon() == null && notification.getText() == null && notification.getTitle() == null) {
            throw new IllegalArgumentException("At least one of <title>, <text> or <icon> must be supplied for the command to succeed.");
        }
        UUID uuid = UUID.randomUUID();
        Action.Builder builder = Action.name("notify").withParameter("app-sig", this.application.getAppSig()).withParameter("id", notification.getClassId()).withParameter("title", notification.getTitle()).withParameter("text", notification.getText()).withParameter("timeout", notification.getTimeout() == null ? -1 : notification.getTimeout()).withParameter("sound", notification.getSound()).withParameter("priority", (Object)notification.getPriority()).withParameter("uuid", uuid);
        if (notification.getIcon() != null) {
            builder.withParameter(notification.getIcon().isBase64() ? "icon-base64" : "icon", notification.getIcon());
        }
        if ((response = this.socket.send(request = Request.builder(this.application).addAction(builder.build()).build())).hasNotSucceeded()) {
            throw new SnpException(response.getError());
        }
        return new NotificationResult(uuid);
    }

    public static SnpNotifier of(@NonNull Application application, @NonNull Server server) {
        if (application == null) {
            throw new NullPointerException("application");
        }
        if (server == null) {
            throw new NullPointerException("server");
        }
        SnpSocketImpl socket = SnpSocketImpl.of(server);
        Action register = Action.name("register").withParameter("app-sig", application.getAppSig()).withParameter("uid", UUID.randomUUID()).withParameter("title", application.getTitle()).build();
        Request request = Request.builder(application).addAction(register).build();
        socket.send(request);
        return new SnpNotifier(application, socket);
    }

    @Override
    public void close() throws IOException {
        Request request = Request.builder(this.application).addAction(Action.name("unregister").withParameter("app-sig", this.application.getAppSig()).build()).build();
        this.socket.send(request);
        this.socket.close();
    }

    SnpNotifier(Application application, SnpSocket socket) {
        this.application = application;
        this.socket = socket;
    }
}

