/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j.impl;

import fr.jcgay.snp4j.Server;
import fr.jcgay.snp4j.SnpException;
import fr.jcgay.snp4j.impl.RequestSerializer;
import fr.jcgay.snp4j.impl.SnpSocket;
import fr.jcgay.snp4j.impl.request.Request;
import fr.jcgay.snp4j.impl.request.Token;
import fr.jcgay.snp4j.impl.response.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnpSocketImpl
implements SnpSocket {
    private static final Logger log = LoggerFactory.getLogger(SnpSocketImpl.class);
    @NonNull
    private final PrintWriter out;
    @NonNull
    private final BufferedReader in;
    @NonNull
    private final Socket socket;
    @NonNull
    private final RequestSerializer serializer;
    private final String password;

    public static SnpSocketImpl of(@NonNull Server server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        try {
            Socket socket = new Socket();
            InetSocketAddress destination = new InetSocketAddress(server.getHost(), server.getPort());
            socket.connect(destination, (int)server.getTimeout());
            socket.setSoTimeout((int)server.getTimeout());
            PrintWriter writer = new PrintWriter(socket.getOutputStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            return new SnpSocketImpl(writer, reader, socket, new RequestSerializer(), server.getPassword());
        }
        catch (IOException e) {
            throw new SnpException("Cannot create notifier, an error occurs while creating the socket.", e);
        }
    }

    @Override
    public Response send(@NonNull Request request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        String toSend = this.serializer.stringify(request, Token.create(this.password).hash());
        log.debug("Sending request: \n{}", (Object)toSend);
        this.out.print(toSend);
        this.out.flush();
        return this.readResponse();
    }

    private Response readResponse() {
        HashMap<String, String> responseElements = new HashMap<String, String>();
        log.debug("Reading response:");
        try {
            String s;
            while ((s = this.in.readLine()) != null) {
                log.debug(s);
                if ("END".equals(s)) break;
                String[] split = s.split(" ", 2);
                responseElements.put(split[0], split[1]);
            }
            return Response.mapBuilder(responseElements).build();
        }
        catch (IOException e) {
            throw new SnpException("Error while reading response.", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.in.close();
        this.socket.close();
    }

    SnpSocketImpl(@NonNull PrintWriter out, @NonNull BufferedReader in, @NonNull Socket socket, @NonNull RequestSerializer serializer, String password) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        if (in == null) {
            throw new NullPointerException("in");
        }
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer");
        }
        this.out = out;
        this.in = in;
        this.socket = socket;
        this.serializer = serializer;
        this.password = password;
    }
}

