/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j.impl.request;

import fr.jcgay.snp4j.impl.request.EmptyParameter;
import fr.jcgay.snp4j.impl.request.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class Action {
    @NonNull
    private final String name;
    @NonNull
    private final List<Parameter> parameters;

    public static Builder name(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return new Builder(name);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Action;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public String toString() {
        return "Action(name=" + this.getName() + ", parameters=" + this.getParameters() + ")";
    }

    private Action(@NonNull String name, @NonNull List<Parameter> parameters) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        this.name = name;
        this.parameters = parameters;
    }

    public static class Builder {
        private String name;
        private List<Parameter> parameters = new ArrayList<Parameter>();

        protected Builder(String name) {
            this.name = name;
        }

        public Builder withParameter(@NonNull Parameter parameter) {
            if (parameter == null) {
                throw new NullPointerException("parameter");
            }
            if (!parameter.equals(EmptyParameter.empty())) {
                this.parameters.add(parameter);
            }
            return this;
        }

        public Builder withParameter(@NonNull String key, Object value) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (value != null) {
                this.parameters.add(Parameter.of(key, value));
            }
            return this;
        }

        public Action build() {
            return new Action(this.name, Collections.unmodifiableList(this.parameters));
        }
    }
}

