/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j.impl.request;

import fr.jcgay.snp4j.Application;
import fr.jcgay.snp4j.impl.request.Action;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class Request {
    @NonNull
    private final List<Action> actions;
    @NonNull
    private final Application application;

    public static Builder builder(@NonNull Application application) {
        if (application == null) {
            throw new NullPointerException("application");
        }
        return new Builder(application);
    }

    @NonNull
    public List<Action> getActions() {
        return this.actions;
    }

    @NonNull
    public Application getApplication() {
        return this.application;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Action> this$actions = this.getActions();
        List<Action> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        Application this$application = this.getApplication();
        Application other$application = other.getApplication();
        return !(this$application == null ? other$application != null : !((Object)this$application).equals(other$application));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        Application $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : ((Object)$application).hashCode());
        return result;
    }

    public String toString() {
        return "Request(actions=" + this.getActions() + ", application=" + this.getApplication() + ")";
    }

    private Request(@NonNull List<Action> actions, @NonNull Application application) {
        if (actions == null) {
            throw new NullPointerException("actions");
        }
        if (application == null) {
            throw new NullPointerException("application");
        }
        this.actions = actions;
        this.application = application;
    }

    public static class Builder {
        private Application application;
        private List<Action> actions = new ArrayList<Action>();

        private Builder(Application application) {
            this.application = application;
        }

        public Builder addAction(@NonNull Action action) {
            if (action == null) {
                throw new NullPointerException("action");
            }
            this.actions.add(action);
            return this;
        }

        public Request build() {
            return new Request(Collections.unmodifiableList(this.actions), this.application);
        }
    }
}

