/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j.impl.request;

import fr.jcgay.snp4j.SnpException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;

public class Token {
    private static final Token NONE = new Token(null, null){

        @Override
        public String hash() {
            return "";
        }
    };
    private final String password;
    private final String salt;

    public static Token none() {
        return NONE;
    }

    public static Token create(String password) {
        if (password == null) {
            return NONE;
        }
        return new Token(password, UUID.randomUUID().toString().replace("-", ""));
    }

    static Token of(String password, String salt) {
        return new Token(password, salt);
    }

    public String hash() {
        return "SHA-256:" + this.passwordWithSalt() + "." + this.salt;
    }

    private String passwordWithSalt() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SnpException("Cannot hash token with SHA-256 algorithm.", e);
        }
        md.update((this.password + this.salt).getBytes());
        return DatatypeConverter.printHexBinary((byte[])md.digest());
    }

    public String getPassword() {
        return this.password;
    }

    public String getSalt() {
        return this.salt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        return !(this$salt == null ? other$salt != null : !this$salt.equals(other$salt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Token;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        return result;
    }

    public String toString() {
        return "Token()";
    }

    private Token(String password, String salt) {
        this.password = password;
        this.salt = salt;
    }
}

