/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.snp4j.impl.response;

import fr.jcgay.snp4j.impl.response.Error;
import fr.jcgay.snp4j.impl.response.Status;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import lombok.NonNull;

public class Response {
    @NonNull
    private final Status status;
    @NonNull
    private final Date time;
    @NonNull
    private final String daemon;
    @NonNull
    private final String host;
    private final Error error;

    public static MapBuilder mapBuilder(@NonNull Map<String, String> responseElements) {
        if (responseElements == null) {
            throw new NullPointerException("responseElements");
        }
        return new MapBuilder(responseElements);
    }

    public static Builder builder(Status status, Date time, String daemon, String host) {
        return new Builder(status, time, daemon, host);
    }

    public boolean hasSucceeded() {
        return this.status == Status.OK;
    }

    public boolean hasNotSucceeded() {
        return !this.hasSucceeded();
    }

    @NonNull
    public Status getStatus() {
        return this.status;
    }

    @NonNull
    public Date getTime() {
        return this.time;
    }

    @NonNull
    public String getDaemon() {
        return this.daemon;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public Error getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        Date this$time = this.getTime();
        Date other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$daemon = this.getDaemon();
        String other$daemon = other.getDaemon();
        if (this$daemon == null ? other$daemon != null : !this$daemon.equals(other$daemon)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Error this$error = this.getError();
        Error other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        Date $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $daemon = this.getDaemon();
        result = result * 59 + ($daemon == null ? 43 : $daemon.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Error $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    public String toString() {
        return "Response(status=" + (Object)((Object)this.getStatus()) + ", time=" + this.getTime() + ", daemon=" + this.getDaemon() + ", host=" + this.getHost() + ", error=" + this.getError() + ")";
    }

    private Response(@NonNull Status status, @NonNull Date time, @NonNull String daemon, @NonNull String host, Error error) {
        if (status == null) {
            throw new NullPointerException("status");
        }
        if (time == null) {
            throw new NullPointerException("time");
        }
        if (daemon == null) {
            throw new NullPointerException("daemon");
        }
        if (host == null) {
            throw new NullPointerException("host");
        }
        this.status = status;
        this.time = time;
        this.daemon = daemon;
        this.host = host;
        this.error = error;
    }

    public static class MapBuilder {
        private final Map<String, String> responseElements;

        protected MapBuilder(Map<String, String> responseElements) {
            this.responseElements = responseElements;
        }

        public Response build() {
            return new Response(this.getStatus(this.responseElements), this.parseTime(this.responseElements.get(Key.TIMESTAMP.value)), this.responseElements.get(Key.DAEMON.value), this.responseElements.get(Key.HOST.value), this.buildError(this.responseElements));
        }

        private Error buildError(Map<String, String> responseElements) {
            Error error = this.parseResult(responseElements.get(Key.RESULT.value));
            if (error != null) {
                return error;
            }
            if (responseElements.containsKey(Key.ERROR_CODE.value)) {
                return new Error(Status.fromCode(responseElements.get(Key.ERROR_CODE.value)), responseElements.get(Key.ERROR_NAME.value), responseElements.get(Key.ERROR_HINT.value));
            }
            return null;
        }

        private Error parseResult(String result) {
            if (result == null) {
                return null;
            }
            String[] elements = result.split(" ", 3);
            Status status = Status.fromCode(elements[1]);
            if (status == Status.OK) {
                return null;
            }
            return new Error(status, elements[2], status.getHint());
        }

        private Date parseTime(String s) {
            try {
                return new SimpleDateFormat("d MMM yyyy HH:mm:ss").parse(s);
            }
            catch (ParseException e) {
                return new Date();
            }
        }

        private Status getStatus(Map<String, String> elements) {
            Error error;
            if (elements.containsKey(Key.RESULT.value) && (error = this.parseResult(elements.get(Key.RESULT.value))) != null) {
                return error.getStatus();
            }
            if (elements.get(Key.HEADER.value).contains("OK")) {
                return Status.OK;
            }
            return Status.fromCode(elements.get(Key.ERROR_CODE.value));
        }

        private static enum Key {
            HEADER("SNP/3.0"),
            TIMESTAMP("x-timestamp:"),
            HOST("x-host:"),
            DAEMON("x-daemon:"),
            RESULT("result:"),
            ERROR_CODE("error-code:"),
            ERROR_NAME("error-name:"),
            ERROR_HINT("error-hint:");

            private String value;

            private Key(String value) {
                this.value = value;
            }
        }
    }

    public static class Builder {
        private final Status status;
        private final Date time;
        private final String daemon;
        private final String host;
        private Error error;

        protected Builder(Status status, Date time, String daemon, String host) {
            this.status = status;
            this.time = time;
            this.daemon = daemon;
            this.host = host;
        }

        public Builder withError(Error error) {
            this.error = error;
            return this;
        }

        public Response build() {
            return new Response(this.status, this.time, this.daemon, this.host, this.error);
        }
    }
}

