/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.util.BufferedImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pipeline
implements ImageFilter {
    private final List<ImageFilter> filtersToApply;
    private final List<ImageFilter> unmodifiableFiltersToApply;

    public Pipeline() {
        this(Collections.emptyList());
    }

    public Pipeline(ImageFilter ... imageFilterArray) {
        this(Arrays.asList(imageFilterArray));
    }

    public Pipeline(List<ImageFilter> list) {
        if (list == null) {
            throw new NullPointerException("Cannot instantiate with a nulllist of image filters.");
        }
        this.filtersToApply = new ArrayList<ImageFilter>(list);
        this.unmodifiableFiltersToApply = Collections.unmodifiableList(this.filtersToApply);
    }

    public void add(ImageFilter imageFilter) {
        if (imageFilter == null) {
            throw new NullPointerException("An image filter must not be null.");
        }
        this.filtersToApply.add(imageFilter);
    }

    public void addFirst(ImageFilter imageFilter) {
        if (imageFilter == null) {
            throw new NullPointerException("An image filter must not be null.");
        }
        this.filtersToApply.add(0, imageFilter);
    }

    public void addAll(List<ImageFilter> list) {
        if (list == null) {
            throw new NullPointerException("A list of image filters must not be null.");
        }
        this.filtersToApply.addAll(list);
    }

    public List<ImageFilter> getFilters() {
        return this.unmodifiableFiltersToApply;
    }

    @Override
    public BufferedImage apply(BufferedImage bufferedImage) {
        if (this.filtersToApply.isEmpty()) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = BufferedImages.copy(bufferedImage);
        for (ImageFilter imageFilter : this.filtersToApply) {
            bufferedImage2 = imageFilter.apply(bufferedImage2);
        }
        return bufferedImage2;
    }
}

