/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler.reporting.json;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.google.common.base.Function;
import fr.jcgay.maven.profiler.reporting.Format;
import fr.jcgay.maven.profiler.reporting.template.Data;
import fr.jcgay.maven.profiler.reporting.template.EntryAndTime;
import fr.jcgay.maven.profiler.reporting.template.Project;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecution;
import org.eclipse.aether.artifact.Artifact;

public enum ToJson implements Function<Data, JsonObject>
{
    INSTANCE;


    public JsonObject apply(@Nullable Data context) {
        JsonObject json = new JsonObject();
        json.add("name", context.getTopProjectName());
        json.add("profile_name", context.getProfileName());
        json.add("time", Format.ms(context.getBuildTime()));
        json.add("goals", context.getGoals());
        json.add("date", context.getFormattedDate());
        json.add("parameters", context.getParameters().toString());
        JsonArray projectsArr = new JsonArray();
        for (Project project : context.getProjects()) {
            JsonObject projectObj = new JsonObject();
            projectObj.add("project", project.getName());
            projectObj.add("time", Format.ms(project.getTime()));
            JsonArray projectMojosArr = new JsonArray();
            for (EntryAndTime<MojoExecution> entry : project.getMojosWithTime()) {
                JsonObject projectMojoObj = new JsonObject();
                projectMojoObj.add("mojo", entry.getEntry().toString());
                projectMojoObj.add("time", Format.ms(entry.getTime()));
                projectMojosArr.add((JsonValue)projectMojoObj);
            }
            projectObj.add("mojos", (JsonValue)projectMojosArr);
            projectsArr.add((JsonValue)projectObj);
        }
        json.add("projects", (JsonValue)projectsArr);
        if (context.isDownloadSectionDisplayed()) {
            JsonArray downloadsArr = new JsonArray();
            for (EntryAndTime<Artifact> download : context.getDownloads()) {
                JsonObject downloadObj = new JsonObject();
                downloadObj.add("download", download.getEntry().toString());
                downloadObj.add("time", Format.ms(download.getTime()));
                downloadsArr.add((JsonValue)downloadObj);
            }
            json.add("downloads", (JsonValue)downloadsArr);
        }
        return json;
    }
}

