package fr.jrds.snmpcodec.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.smi.Oid;
import fr.jrds.snmpcodec.smi.Symbol;

public class OidPath extends ArrayList<OidPath.OidComponent> {

    public static class OidComponent {
        public final int number;
        public final String name;
        public OidComponent(String name, int number) {
            this.number = number;
            this.name = name;
        }
        @Override
        public String toString() {
            return String.format("%s%d%s", name !=null ? name + "(": "", 
                    number,
                    name != null ? ")": "");
        }
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((name == null) ? 0 : name.hashCode());
            result = prime * result + number;
            return result;
        }
        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (getClass() != obj.getClass())
                return false;
            OidComponent other = (OidComponent) obj;
            if (name == null) {
                if (other.name != null)
                    return false;
            } else if (!name.equals(other.name))
                return false;
            return number == other.number;
        }
    }

    Symbol root;

    OidPath() {
        super();
    }

    @Override
    public String toString() {
        return (root != null ? root  + "." : "")
                + stream().map(OidComponent::toString).collect(Collectors.joining("."));
    }

    Symbol getRoot() {
        return root;
    }

    public List<OidPath.OidComponent> getComponents() {
        return new ArrayList<>(this);
    }

    public Stream<Oid> getAll(boolean tableEntry) {
        List<OidPath.OidComponent> stack = new ArrayList<>(this.size());
        return stream().map(i -> {
            try {
                List<OidPath.OidComponent> newPath = new ArrayList<>(stack.size());
                stack.add(i);
                newPath.addAll(stack);
                return new Oid(root, newPath, i.name);
            } catch (MibException e) {
                throw e.getNonChecked();
            }
        }).limit(size() - 1L);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        if (!super.equals(o))
            return false;
        OidPath that = (OidPath) o;
        return (root == null && that.root == null) || root.equals(that.root);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), root);
    }

}
