/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec;

import fr.jrds.snmpcodec.smi.Symbol;

public class MibException
extends Exception {
    public MibException(String message) {
        super(message);
    }

    public NonCheckedMibException getNonChecked() {
        throw new NonCheckedMibException();
    }

    public class NonCheckedMibException
    extends RuntimeException {
        public MibException getWrapper() {
            return MibException.this;
        }

        @Override
        public String getMessage() {
            return MibException.this.getMessage();
        }
    }

    public static class MissingSymbol
    extends MibException {
        public MissingSymbol(String message) {
            super(message);
        }
    }

    public static class DuplicatedSymbolOid
    extends MibException {
        private final String oid;

        public DuplicatedSymbolOid(String oid) {
            super("Duplicated OID " + oid);
            this.oid = oid;
        }

        public String getSymbol() {
            return this.oid;
        }
    }

    public static class DuplicatedSymbolException
    extends MibException {
        private final Symbol symbol;

        public DuplicatedSymbolException(Symbol symbol) {
            super("Duplicated symbol " + String.valueOf(symbol));
            this.symbol = symbol;
        }

        public Symbol getSymbol() {
            return this.symbol;
        }
    }

    public static class DuplicatedModuleException
    extends MibException {
        private final String module;

        public DuplicatedModuleException(String module) {
            super("Duplicated module " + module);
            this.module = module;
        }

        public String getModule() {
            return this.module;
        }
    }
}

