/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec;

import fr.jrds.snmpcodec.OidTreeNode;
import fr.jrds.snmpcodec.parsing.MibLoader;
import fr.jrds.snmpcodec.smi.Index;
import fr.jrds.snmpcodec.smi.ObjectType;
import fr.jrds.snmpcodec.smi.Syntax;
import fr.jrds.snmpcodec.smi.Trap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public abstract class MibStore {
    public final OidTreeNode top;
    public final Map<String, List<OidTreeNode>> names;
    public final Map<String, Syntax> syntaxes;
    public final Map<OidTreeNode, ObjectType> objects;
    public final Map<OidTreeNode, Map<Integer, Trap>> resolvedTraps;
    public final Set<String> modules;

    protected MibStore(OidTreeNode top, Set<String> modules, Map<String, List<OidTreeNode>> names, Map<String, Syntax> syntaxes, Map<OidTreeNode, ObjectType> objects, Map<OidTreeNode, Map<Integer, Trap>> resolvedTraps) {
        this.syntaxes = Collections.unmodifiableMap(syntaxes);
        this.objects = Collections.unmodifiableMap(objects);
        this.resolvedTraps = Collections.unmodifiableMap(resolvedTraps);
        this.modules = Collections.unmodifiableSet(modules);
        this.names = Collections.unmodifiableMap(names);
        this.top = top;
    }

    public Map<String, Object> parseIndexOID(int[] oid) {
        Map<String, Object> parts;
        OidTreeNode found = this.top.search(oid);
        if (found == null) {
            return Collections.emptyMap();
        }
        int[] foundOID = found.getElements();
        if (foundOID.length < oid.length) {
            ObjectType parentCodec;
            if (found.getTableEntry() == null) {
                if (foundOID.length == oid.length - 1 && oid[oid.length - 1] == 0) {
                    return Collections.singletonMap(found.getSymbol(), found.getSymbol());
                }
                int[] numberPart = Arrays.copyOfRange(oid, foundOID.length, oid.length);
                return Collections.singletonMap(found.getSymbol(), new Object[]{found.getSymbol(), numberPart});
            }
            parts = new LinkedHashMap<String, String>();
            parts.put(found.getTableEntry().getSymbol(), found.getSymbol());
            OidTreeNode parent = this.top.find(Arrays.copyOf(foundOID, foundOID.length - 1));
            if (parent != null && (parentCodec = this.objects.get(parent)).isIndexed()) {
                Index idx = parentCodec.getIndex();
                int[] index = Arrays.copyOfRange(oid, foundOID.length, oid.length);
                parts.putAll(idx.resolve(index, this));
            }
        } else {
            parts = Collections.singletonMap(found.getSymbol(), found.getSymbol());
        }
        return parts;
    }

    public boolean containsKey(String text) {
        return this.names.containsKey(text);
    }

    public int[] getFromName(String text) {
        return Optional.ofNullable(this.names.get(text)).map(i -> i.stream().findFirst().map(OidTreeNode::getElements).orElseGet(() -> new int[0])).orElseGet(() -> new int[0]);
    }

    public String format(OID instanceOID, Variable variable) {
        OidTreeNode node = this.top.search(instanceOID.getValue());
        if (node == null) {
            return null;
        }
        if (this.resolvedTraps.containsKey(node)) {
            Trap trap = this.resolvedTraps.get(node).get(variable.toInt());
            if (trap == null) {
                return null;
            }
            return trap.name;
        }
        if (this.objects.containsKey(node)) {
            ObjectType ot = this.objects.get(node);
            return ot.format(variable);
        }
        return null;
    }

    public Variable parse(OID instanceOID, String text) {
        OidTreeNode node = this.top.search(instanceOID.getValue());
        if (node == null) {
            return null;
        }
        if (this.syntaxes.containsKey(node.getSymbol())) {
            return this.syntaxes.get(node.getSymbol()).parse(text);
        }
        if (this.objects.containsKey(node)) {
            Syntax s = this.objects.get(node).getSyntax();
            return s.parse(text);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public static MibStore load(String ... mibdirs) {
        MibLoader loader = new MibLoader();
        Arrays.stream(mibdirs).map(x$0 -> Paths.get(x$0, new String[0])).filter(i -> {
            try {
                File dest = i.toRealPath(new LinkOption[0]).toFile();
                return dest.isDirectory() || dest.isFile();
            }
            catch (IOException e) {
                return false;
            }
        }).map(MibStore::scanDirectory).forEach(loader::load);
        return loader.buildTree();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Path[] scanDirectory(Path i) {
        Path[] pathArray;
        if (!i.toRealPath(new LinkOption[0]).toFile().isDirectory()) return new Path[]{i};
        Stream<Path> files = Files.list(i);
        try {
            pathArray = (Path[])files.filter(j -> {
                try {
                    File f = j.toRealPath(LinkOption.NOFOLLOW_LINKS).toFile();
                    return f.isFile() && !f.isHidden();
                }
                catch (IOException e) {
                    return false;
                }
            }).toArray(Path[]::new);
            if (files == null) return pathArray;
        }
        catch (Throwable throwable) {
            try {
                if (files == null) throw throwable;
                try {
                    files.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return new Path[0];
            }
        }
        files.close();
        return pathArray;
    }
}

