/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec;

import fr.jrds.snmpcodec.MibStore;
import fr.jrds.snmpcodec.smi.SmiType;
import java.io.File;
import java.text.ParseException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.OIDTextFormat;
import org.snmp4j.util.VariableTextFormat;

public class OIDFormatter
implements OIDTextFormat,
VariableTextFormat {
    public static final String MIBDIRSPROPERTY = "snmpcodec.mibdirs";
    public static final String MIBDIRSPROPERTY_DEFAULT = "/usr/share/snmp/mibs";
    private static final Pattern OIDWITSUFFIX = Pattern.compile("(?<prefix>\\p{L}(?:\\p{L}|\\d)+)(?:\\.(?<oids>\\d+(?:\\.\\d*)*))?");
    public final MibStore store;
    private OIDTextFormat previous;
    private VariableTextFormat previousVar;

    public OIDFormatter(MibStore resolver) {
        this.store = resolver;
        this.previous = SNMP4JSettings.getOIDTextFormat();
        this.previousVar = SNMP4JSettings.getVariableTextFormat();
    }

    public static OIDFormatter register() {
        String[] mibdirs = System.getProperty(MIBDIRSPROPERTY, MIBDIRSPROPERTY_DEFAULT).split(File.pathSeparator);
        return OIDFormatter.register(mibdirs);
    }

    public static OIDFormatter register(String ... mibdirs) {
        MibStore resolver = MibStore.load(mibdirs);
        return OIDFormatter.register(resolver);
    }

    public static OIDFormatter register(MibStore resolver) {
        OIDTextFormat previousTextFormat = SNMP4JSettings.getOIDTextFormat();
        VariableTextFormat previousVarFormat = SNMP4JSettings.getVariableTextFormat();
        OIDFormatter formatter = new OIDFormatter(resolver);
        SNMP4JSettings.setOIDTextFormat((OIDTextFormat)formatter);
        SNMP4JSettings.setVariableTextFormat((VariableTextFormat)formatter);
        if (previousTextFormat instanceof OIDFormatter) {
            formatter.previous = ((OIDFormatter)previousTextFormat).previous;
        }
        if (previousVarFormat instanceof OIDFormatter) {
            formatter.previousVar = ((OIDFormatter)previousVarFormat).previousVar;
        }
        return formatter;
    }

    public String format(int[] value) {
        if (this.store.isEmpty()) {
            return this.previous.format(value);
        }
        Object[] parsed = this.store.parseIndexOID(value).values().toArray();
        if (parsed != null && parsed.length > 0) {
            if (parsed.length == 1 && parsed[0].getClass().isArray()) {
                Object[] content = (Object[])parsed[0];
                String prefix = (String)content[0];
                int[] numberPart = (int[])content[1];
                String suffix = Arrays.stream(numberPart).mapToObj(Integer::toString).collect(Collectors.joining("."));
                return prefix + "." + suffix;
            }
            StringBuilder buffer = new StringBuilder(parsed[0].toString());
            IntStream.range(1, parsed.length).forEach(i -> buffer.append("[").append(parsed[i]).append("]"));
            return buffer.toString();
        }
        return this.previous.format(value);
    }

    public String formatForRoundTrip(int[] value) {
        return this.format(value);
    }

    public int[] parse(String text) throws ParseException {
        String prefixString;
        int[] prefix;
        if (text == null || this.store.isEmpty()) {
            return this.previous.parse(text);
        }
        Matcher m = OIDWITSUFFIX.matcher(text);
        if (m.matches() && (prefix = this.store.getFromName(prefixString = m.group("prefix"))) != null) {
            int[] parsed;
            if (m.group("oids") != null) {
                String[] oids = m.group("oids").split("\\.");
                parsed = new int[prefix.length + oids.length];
                System.arraycopy(prefix, 0, parsed, 0, prefix.length);
                int i = prefix.length;
                int j = 0;
                while (i < parsed.length) {
                    parsed[i] = Integer.parseInt(oids[j]);
                    ++i;
                    ++j;
                }
            } else {
                parsed = prefix;
            }
            return parsed;
        }
        return this.previous.parse(text);
    }

    public String format(OID instanceOID, Variable variable, boolean withOID) {
        String formatted = this.store.format(instanceOID, variable);
        if (formatted != null) {
            return formatted;
        }
        return this.previousVar.format(instanceOID, variable, withOID);
    }

    public VariableBinding parseVariableBinding(String text) throws ParseException {
        return this.previousVar.parseVariableBinding(text);
    }

    public Variable parse(OID classOrInstanceOID, String text) throws ParseException {
        Variable v = this.store.parse(classOrInstanceOID, text);
        if (v != null) {
            return v;
        }
        return this.previousVar.parse(classOrInstanceOID, text);
    }

    public Variable parse(int smiSyntax, String text) throws ParseException {
        switch (smiSyntax) {
            case 2: {
                return SmiType.INTEGER.parse(text);
            }
            case 4: {
                return SmiType.OctetString.parse(text);
            }
            case 5: {
                return new Null();
            }
            case 6: {
                return SmiType.ObjID.parse(text);
            }
            case 64: {
                return SmiType.IpAddr.parse(text);
            }
            case 65: {
                return SmiType.Counter32.parse(text);
            }
            case 66: {
                return SmiType.Gauge32.parse(text);
            }
            case 67: {
                return SmiType.TimeTicks.parse(text);
            }
            case 68: {
                return SmiType.Opaque.parse(text);
            }
            case 70: {
                return SmiType.Counter64.parse(text);
            }
        }
        return this.previousVar.parse(smiSyntax, text);
    }
}

