/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec;

import fr.jrds.snmpcodec.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.snmp4j.smi.OID;

public abstract class OidTreeNode {
    private final String name;
    protected int[] oidElements;
    private final NavigableMap<Integer, OidTreeNode> childs = new TreeMap<Integer, OidTreeNode>();
    protected final OidTreeNode root;
    private final boolean isTableEntry;
    private final OidTreeNode parent;

    protected OidTreeNode() {
        this.name = null;
        this.root = this;
        this.oidElements = new int[0];
        this.isTableEntry = false;
        this.parent = null;
    }

    protected OidTreeNode(OidTreeNode parent, int id, String name, boolean isTableEntry) {
        this.parent = parent;
        this.name = name;
        this.root = parent.root;
        parent.childs.put(id, this);
        this.oidElements = Arrays.copyOf(parent.oidElements, parent.oidElements.length + 1);
        this.oidElements[this.oidElements.length - 1] = id;
        this.isTableEntry = isTableEntry;
    }

    public String getSymbol() {
        return this.name;
    }

    public OidTreeNode getParent() {
        return this.parent;
    }

    public OidTreeNode search(int[] oid) {
        if (oid.length > 0 && this.root.childs.containsKey(oid[0])) {
            return ((OidTreeNode)this.root.childs.get(oid[0])).search(oid, 1);
        }
        return null;
    }

    private OidTreeNode search(int[] oid, int level) {
        if (oid.length == level) {
            return this;
        }
        int key = oid[level];
        if (this.childs.containsKey(key)) {
            return ((OidTreeNode)this.childs.get(key)).search(oid, level + 1);
        }
        return this;
    }

    public OidTreeNode find(int[] oid) {
        OidTreeNode found = this.search(oid);
        if (found != null && found.oidEquals(oid)) {
            return found;
        }
        return null;
    }

    public String toString() {
        return (this.oidElements != null ? Utils.dottedNotation(this.oidElements) : "") + "=" + (this.name != null ? this.name : "");
    }

    public int[] getElements() {
        return Arrays.copyOf(this.oidElements, this.oidElements.length);
    }

    protected int[] getElementsPrivate() {
        return this.oidElements;
    }

    public OID getOID() {
        return new OID(this.oidElements);
    }

    public boolean oidEquals(int[] other) {
        return other != null && Arrays.equals(this.oidElements, other);
    }

    public Collection<OidTreeNode> childs() {
        return Collections.unmodifiableCollection(this.childs.values());
    }

    public OidTreeNode getTableEntry() {
        OidTreeNode curs = this;
        while (curs != null && !curs.isTableEntry) {
            curs = curs.parent;
        }
        if (curs != null && curs.isTableEntry) {
            return curs.parent;
        }
        return null;
    }
}

