/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec;

import java.util.Arrays;
import java.util.stream.Collectors;

public class Utils {
    private Utils() {
    }

    public static String dottedNotation(int[] elements) {
        return Arrays.stream(elements).mapToObj(i -> Long.toString((long)i & 0xFFFFFFFFL)).collect(Collectors.joining("."));
    }

    public static UnsignedLong getUnsigned(long l) {
        return new UnsignedLong(l);
    }

    public static final class UnsignedLong
    extends Number
    implements Comparable<Long> {
        private final long l;

        private UnsignedLong(long l) {
            this.l = l;
        }

        @Override
        public byte byteValue() {
            return (byte)this.l;
        }

        @Override
        public short shortValue() {
            return (short)this.l;
        }

        @Override
        public int intValue() {
            return (int)this.l;
        }

        @Override
        public long longValue() {
            return this.l;
        }

        @Override
        public float floatValue() {
            return this.l;
        }

        @Override
        public double doubleValue() {
            return this.l;
        }

        public String toString() {
            return Long.toUnsignedString(this.l);
        }

        public int hashCode() {
            return Long.hashCode(this.l);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Long) {
                return this.l == (Long)obj;
            }
            return false;
        }

        @Override
        public int compareTo(Long l2) {
            return Long.compareUnsigned(this.l, l2);
        }
    }
}

