/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.log;

import fr.jrds.snmpcodec.log.LogString;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;

public class LogAdapter {
    private static final Map<String, LogAdapter> loggercache = new ConcurrentHashMap<String, LogAdapter>();
    private final org.snmp4j.log.LogAdapter adapter;

    public static LogAdapter getLogger(Class<?> c) {
        return LogAdapter.getLogger(c.getName());
    }

    public static LogAdapter getLogger(String l) {
        return loggercache.computeIfAbsent(l, LogAdapter::new);
    }

    private LogAdapter(String l) {
        this.adapter = LogFactory.getLogger((String)l);
    }

    public boolean isDebugEnabled() {
        return this.adapter.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.adapter.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.adapter.isWarnEnabled();
    }

    public void debug(String format, Object ... args) {
        this.adapter.debug((Serializable)LogString.make(format, args));
    }

    public void info(String format, Object ... args) {
        this.adapter.info((CharSequence)LogString.make(format, args));
    }

    public void warn(String format, Object ... args) {
        this.adapter.warn((Serializable)LogString.make(format, args));
    }

    public void error(String format, Object ... args) {
        this.adapter.error((Serializable)LogString.make(format, args));
    }

    public void fatal(String format, Object ... args) {
        this.adapter.fatal((Object)LogString.make(format, args));
    }

    public void error(Throwable throwable, String format, Object ... args) {
        this.adapter.error((CharSequence)LogString.make(format, args), throwable);
    }

    public void fatal(Throwable throwable, String format, Object ... args) {
        this.adapter.fatal((CharSequence)LogString.make(format, args), throwable);
    }

    public void setLogLevel(LogLevel level) {
        this.adapter.setLogLevel(level);
    }

    public LogLevel getLogLevel() {
        return this.adapter.getLogLevel();
    }

    public LogLevel getEffectiveLogLevel() {
        return this.adapter.getEffectiveLogLevel();
    }

    public String getName() {
        return this.adapter.getName();
    }

    public Iterator<?> getLogHandler() {
        return this.adapter.getLogHandler();
    }
}

