/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.parsing;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.MibStore;
import fr.jrds.snmpcodec.OidTreeNode;
import fr.jrds.snmpcodec.log.LogAdapter;
import fr.jrds.snmpcodec.parsing.ASNLexer;
import fr.jrds.snmpcodec.parsing.ASNParser;
import fr.jrds.snmpcodec.parsing.MibStoreImpl;
import fr.jrds.snmpcodec.parsing.ModuleErrorListener;
import fr.jrds.snmpcodec.parsing.ModuleListener;
import fr.jrds.snmpcodec.parsing.NullSyntax;
import fr.jrds.snmpcodec.parsing.ObjectTypeBuilder;
import fr.jrds.snmpcodec.parsing.OidPath;
import fr.jrds.snmpcodec.parsing.OidTreeNodeImpl;
import fr.jrds.snmpcodec.parsing.WrappedException;
import fr.jrds.snmpcodec.smi.AnnotedSyntax;
import fr.jrds.snmpcodec.smi.ObjectType;
import fr.jrds.snmpcodec.smi.Oid;
import fr.jrds.snmpcodec.smi.Referenced;
import fr.jrds.snmpcodec.smi.Symbol;
import fr.jrds.snmpcodec.smi.Syntax;
import fr.jrds.snmpcodec.smi.TextualConvention;
import fr.jrds.snmpcodec.smi.Trap;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class MibLoader {
    public static final LogAdapter MIBPARSINGLOGGER = LogAdapter.getLogger(MibLoader.class);
    public static final LogAdapter MIBPARSINGLOGGERERROR = LogAdapter.getLogger(MibStore.class.getPackage().getName() + ".MibParsingError");
    private final ModuleListener modulelistener;
    private final ANTLRErrorListener errorListener;
    private final Properties encodings;
    private final Set<Oid> allOids = new HashSet<Oid>();
    private final Set<Oid> tableEntryOid = new HashSet<Oid>();
    private final Set<Symbol> badsymbols = new HashSet<Symbol>();
    private final Map<Symbol, Oid> buildOids = new HashMap<Symbol, Oid>();
    private final Map<List<Integer>, OidTreeNode> nodes = new HashMap<List<Integer>, OidTreeNode>();
    private final Map<Symbol, Syntax> types = new HashMap<Symbol, Syntax>();
    private final Map<Object, Map<Integer, Map<String, Object>>> buildTraps = new HashMap<Object, Map<Integer, Map<String, Object>>>();
    private final Map<Symbol, Map<String, Object>> textualConventions = new HashMap<Symbol, Map<String, Object>>();
    private final Map<Oid, ObjectTypeBuilder> buildObjects = new HashMap<Oid, ObjectTypeBuilder>();
    private final OidTreeNodeImpl top = new OidTreeNodeImpl();
    private final Map<String, List<OidTreeNode>> names = new HashMap<String, List<OidTreeNode>>();
    private final Set<String> modules = new HashSet<String>();
    private final Map<String, Syntax> syntaxes = new HashMap<String, Syntax>();
    private final Map<OidTreeNode, ObjectType> objects = new HashMap<OidTreeNode, ObjectType>();
    private final Map<OidTreeNode, Map<Integer, Trap>> resolvedTraps = new HashMap<OidTreeNode, Map<Integer, Trap>>();

    public MibLoader() {
        try {
            this.addRoot("ccitt", 0);
            this.addRoot("iso", 1);
            this.addRoot("joint-iso-ccitt", 2);
            this.addRoot("broken-module", -1);
        }
        catch (MibException mibException) {
            // empty catch block
        }
        this.modulelistener = new ModuleListener(this);
        this.errorListener = new ModuleErrorListener(this.modulelistener);
        this.encodings = new Properties();
        try {
            Collections.list(ClassLoader.getSystemResources("modulesencoding.txt")).forEach(i -> {
                try {
                    InputStream is = i.openStream();
                    this.encodings.load(is);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Invalid modules encoding property file: " + e.getMessage(), e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Invalid modules encoding property file: " + e.getMessage(), e);
        }
    }

    private void addRoot(String name, int num) throws MibException {
        Symbol s = new Symbol(name);
        OidPath path = new OidPath();
        path.add(new OidPath.OidComponent(name, num));
        this.addOid(s, path, false);
    }

    private void load(Stream<CharStream> source) {
        source.filter(i -> {
            this.modulelistener.firstError = true;
            return true;
        }).map(i -> {
            ASNLexer lexer = new ASNLexer((CharStream)i);
            lexer.removeErrorListeners();
            lexer.addErrorListener(this.errorListener);
            return lexer;
        }).map(CommonTokenStream::new).map(i -> {
            ASNParser parser = new ASNParser((TokenStream)i);
            parser.removeErrorListeners();
            parser.addErrorListener(this.errorListener);
            this.modulelistener.parser = parser;
            return parser;
        }).map(i -> {
            try {
                return i.fileContent();
            }
            catch (WrappedException e) {
                MIBPARSINGLOGGERERROR.warn("Not a valid module: " + e.getMessage() + " " + e.getLocation(), new Object[0]);
                return null;
            }
        }).filter(Objects::nonNull).forEach(i -> {
            try {
                ParseTreeWalker.DEFAULT.walk((ParseTreeListener)this.modulelistener, (ParseTree)i);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (MibException.NonCheckedMibException e) {
                try {
                    throw e.getWrapper();
                }
                catch (MibException.DuplicatedModuleException e2) {
                    MIBPARSINGLOGGERERROR.info(e2.getMessage(), new Object[0]);
                }
                catch (MibException.DuplicatedSymbolException e2) {
                    LogAdapter miblogger = LogAdapter.getLogger(MibStore.class.getName() + ".mib." + e2.getSymbol().module);
                    if (miblogger.isInfoEnabled()) {
                        miblogger.info(miblogger.getName() + e2.getMessage(), new Object[0]);
                    }
                }
                catch (MibException e2) {
                    MIBPARSINGLOGGERERROR.error(e2, e2.getMessage(), new Object[0]);
                }
            }
        });
    }

    public void load(InputStream ... sources) throws IOException {
        try {
            Stream<CharStream> antltrstream = Arrays.stream(sources).map(i -> {
                try {
                    return CharStreams.fromStream((InputStream)i);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.load(antltrstream);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public void load(Reader ... sources) throws IOException {
        try {
            Stream<CharStream> antltrstream = Arrays.stream(sources).map(i -> {
                try {
                    return CharStreams.fromReader((Reader)i);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.load(antltrstream);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public void load(String encoding, Path ... sources) {
        Stream<CharStream> antltrstream = Arrays.stream(sources).map(i -> {
            String moduleencoding = encoding;
            if (moduleencoding == null) {
                String filename = i.getFileName().toString();
                moduleencoding = this.encodings.getProperty(filename, "ASCII");
            }
            if ("skip".equals(moduleencoding)) {
                return null;
            }
            try {
                return CharStreams.fromPath((Path)i, (Charset)Charset.forName(moduleencoding));
            }
            catch (IllegalCharsetNameException e) {
                MIBPARSINGLOGGER.error("Invalid charset for %s: %s", i, moduleencoding);
                return null;
            }
            catch (IOException e) {
                MIBPARSINGLOGGER.error("Invalid MIB source %s: %s", i, e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull);
        this.load(antltrstream);
    }

    public void load(Path ... sources) {
        this.load((String)null, sources);
    }

    public MibStore buildTree() {
        MIBPARSINGLOGGER.debug("Starting to build the MIB", new Object[0]);
        MibStoreImpl newStore = new MibStoreImpl(this.top, this.modules, this.names, this.syntaxes, this.objects, this.resolvedTraps);
        Properties props = new Properties();
        try {
            Collections.list(ClassLoader.getSystemResources("symbolsalias.txt")).forEach(i -> {
                try {
                    InputStream is = i.openStream();
                    props.load(is);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Invalid symbols aliases file: " + e.getMessage(), e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Invalid symbols aliases file: " + e.getMessage(), e);
        }
        MIBPARSINGLOGGER.debug("Creating the aliases for bad symbols", new Object[0]);
        props.entrySet().iterator().forEachRemaining(i -> {
            Symbol bad = new Symbol(i.getKey().toString());
            Symbol good = new Symbol(i.getValue().toString());
            if (this.buildOids.containsKey(good) && !this.badsymbols.contains(bad)) {
                MIBPARSINGLOGGERERROR.debug("adding invalid symbol mapping: %s -> %s", bad, good);
                this.buildOids.put(bad, this.buildOids.get(good));
                this.badsymbols.add(bad);
            }
            if (this.types.containsKey(good) && !this.badsymbols.contains(bad)) {
                MIBPARSINGLOGGERERROR.debug("adding invalid type declaration mapping: %s -> %s", bad, good);
                this.types.put(bad, this.types.get(good));
            }
            if (this.textualConventions.containsKey(good) && !this.badsymbols.contains(bad)) {
                MIBPARSINGLOGGERERROR.debug("adding invalid textual convention declaration mapping: %s -> %s", bad, good);
                this.textualConventions.put(bad, this.textualConventions.get(good));
            }
        });
        MIBPARSINGLOGGER.debug("Sorting the OID", new Object[0]);
        Set<Oid> sortedOid = this.sortdOids();
        this.allOids.clear();
        MIBPARSINGLOGGER.debug("Building the OID tree", new Object[0]);
        sortedOid.forEach(oid -> {
            try {
                int[] content = oid.getPath(this.buildOids).stream().mapToInt(Integer::intValue).toArray();
                OidTreeNode node = this.top.add(content, oid.getName(), this.tableEntryOid.contains(oid));
                this.nodes.put(oid.getPath(this.buildOids), node);
                this.names.computeIfAbsent(oid.getName(), i -> new ArrayList()).add(node);
            }
            catch (MibException e) {
                try {
                    int[] content = oid.getPath(this.buildOids).stream().mapToInt(Integer::intValue).toArray();
                    this.top.add(content, oid.getName(), this.tableEntryOid.contains(oid));
                }
                catch (MibException e1) {
                    MIBPARSINGLOGGERERROR.error(e1, e1.getMessage(), new Object[0]);
                }
                MIBPARSINGLOGGERERROR.error(e, e.getMessage(), new Object[0]);
            }
        });
        MIBPARSINGLOGGERERROR.debug("Resolving the types", new Object[0]);
        this.types.entrySet().stream().filter(i -> i.getValue() != null).forEach(i -> {
            try {
                ((Syntax)i.getValue()).resolve(this.types);
            }
            catch (MibException e) {
                MIBPARSINGLOGGERERROR.warn("Can't resolve type %s: %s", i.getKey(), e.getMessage());
            }
        });
        MIBPARSINGLOGGERERROR.debug("Resolving the textual conventions", new Object[0]);
        this.resolveTextualConventions();
        this.types.forEach((i, j) -> this.syntaxes.put(i.name, (Syntax)j));
        MIBPARSINGLOGGERERROR.debug("Building the objects", new Object[0]);
        HashMap<OidTreeNode, ObjectTypeBuilder> augmenters = new HashMap<OidTreeNode, ObjectTypeBuilder>();
        this.buildObjects.forEach((k, v) -> {
            int[] components = null;
            OidTreeNode node = null;
            try {
                components = k.getPath(this.buildOids).stream().mapToInt(Integer::intValue).toArray();
                node = this.top.find(components);
                if (v.isAugmenter()) {
                    augmenters.put(node, (ObjectTypeBuilder)v);
                } else {
                    ObjectType object = v.resolve(this);
                    this.objects.put(node, object);
                }
            }
            catch (MibException e) {
                Object objectname = null;
                objectname = node != null ? node.getSymbol() : "OID " + String.valueOf(k);
                MIBPARSINGLOGGERERROR.warn("Incomplete %s: %s", objectname, e.getMessage());
            }
        });
        augmenters.forEach((k, v) -> {
            Symbol augmented = v.getAugmented();
            Oid oidAugmented = this.buildOids.get(augmented);
            if (oidAugmented == null) {
                MIBPARSINGLOGGERERROR.warn("Unknown reference from %s: %s", k, augmented);
            } else {
                ObjectTypeBuilder builderAugmented = this.buildObjects.get(oidAugmented);
                try {
                    ObjectType object = v.resolve(this, builderAugmented);
                    this.objects.put((OidTreeNode)k, object);
                }
                catch (MibException e) {
                    MIBPARSINGLOGGERERROR.warn("Incomplete OID %s: %s", k, e.getMessage());
                }
            }
        });
        MIBPARSINGLOGGER.debug("Building the SNMPv1 traps", new Object[0]);
        this.buildTraps.forEach((i, j) -> {
            try {
                Oid oid;
                if (i instanceof OidPath) {
                    OidPath p = (OidPath)i;
                    oid = new Oid(p.getRoot(), p.getComponents(), null);
                } else if (i instanceof Symbol) {
                    Symbol s = (Symbol)i;
                    oid = this.buildOids.get(s);
                    if (oid == null) {
                        throw new MibException("Trap's enterprise unknown " + String.valueOf(s));
                    }
                } else {
                    throw new MibException("Wrong enterprise type " + i.getClass().getName());
                }
                List<Integer> path = oid.getPath(this.buildOids);
                if (path == null) {
                    throw new MibException("Can't resolve path " + String.valueOf(oid));
                }
                int[] oidPath = path.stream().mapToInt(Integer::intValue).toArray();
                OidTreeNode node = this.top.find(oidPath);
                HashMap traps = new HashMap(j.size());
                j.forEach((k, l) -> {
                    try {
                        traps.put(k, new Trap((Map<String, Object>)l));
                    }
                    catch (MibException e) {
                        MIBPARSINGLOGGERERROR.warn("Invalid trap: %s", e.getMessage());
                    }
                });
                this.resolvedTraps.computeIfAbsent(node, k -> new HashMap()).putAll(traps);
            }
            catch (MibException e1) {
                MIBPARSINGLOGGERERROR.warn("Invalid trap: %s", e1.getMessage());
            }
        });
        return newStore;
    }

    private void resolveTextualConventions() {
        int resolvCount = 0;
        int oldResolvCount = -1;
        HashSet<Symbol> notDone = new HashSet<Symbol>(this.textualConventions.keySet());
        block3: while (this.textualConventions.size() != resolvCount && resolvCount != oldResolvCount) {
            oldResolvCount = resolvCount;
            for (Map.Entry<Symbol, Map<String, Object>> e : this.textualConventions.entrySet()) {
                Symbol s = e.getKey();
                if (!notDone.contains(s)) continue;
                Map<String, Object> attributes = e.getValue();
                Syntax type = (Syntax)attributes.get("SYNTAX");
                String hint = (String)attributes.get("DISPLAY-HINT");
                try {
                    type.resolve(this.types);
                    TextualConvention tc = type.getTextualConvention(hint, type);
                    this.types.put(s, tc);
                }
                catch (MibException.MissingSymbol ex) {
                    Symbol ref;
                    Syntax invalidType = type;
                    if (invalidType instanceof AnnotedSyntax) {
                        invalidType = ((AnnotedSyntax)invalidType).getSyntax();
                    }
                    if (invalidType instanceof Referenced && this.textualConventions.containsKey(ref = ((Referenced)invalidType).getSymbol())) continue;
                    MIBPARSINGLOGGERERROR.warn("Invalid textual convention %s: %s", s, ex.getMessage());
                }
                catch (MibException | MibException.NonCheckedMibException ex) {
                    MIBPARSINGLOGGERERROR.warn("Invalid textual convention %s: %s", s, ex.getMessage());
                }
                notDone.remove(s);
                if (++resolvCount != this.textualConventions.size()) continue;
                continue block3;
            }
        }
        if (notDone.isEmpty()) {
            MIBPARSINGLOGGERERROR.debug("missing textual convention %d", notDone.size());
        }
        Symbol dateAndTime = new Symbol("SNMPv2-TC", "DateAndTime");
        this.types.computeIfPresent(dateAndTime, (k, v) -> new TextualConvention.DateAndTime());
        Symbol displayString = new Symbol("SNMPv2-TC", "DisplayString");
        this.types.computeIfPresent(displayString, (k, v) -> new TextualConvention.DisplayString());
    }

    private Set<Oid> sortdOids() {
        TreeSet<Oid> sortedoid = new TreeSet<Oid>((o1, o2) -> {
            try {
                int sorted = Integer.compare(o1.getPath(this.buildOids).size(), o2.getPath(this.buildOids).size());
                if (sorted == 0) {
                    int v2;
                    int v1;
                    List<Integer> l1 = o1.getPath(this.buildOids);
                    List<Integer> l2 = o2.getPath(this.buildOids);
                    int length = l1.size();
                    for (int i = 0; i < length && (sorted = Integer.compare(v1 = l1.get(i).intValue(), v2 = l2.get(i).intValue())) == 0; ++i) {
                    }
                }
                if (sorted == 0) {
                    sorted = String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
                }
                return sorted;
            }
            catch (MibException e) {
                throw e.getNonChecked();
            }
        });
        this.allOids.forEach(i -> {
            boolean isTableEntry = this.tableEntryOid.contains(i);
            try {
                List<Integer> path = i.getPath(this.buildOids);
                if (!path.isEmpty()) {
                    Oid newi = new Oid(i.getPath(this.buildOids), i.getName());
                    sortedoid.add(newi);
                    if (isTableEntry) {
                        this.tableEntryOid.add(newi);
                    }
                } else {
                    MIBPARSINGLOGGERERROR.warn("Can't resolve OID %s path", i);
                }
            }
            catch (MibException | MibException.NonCheckedMibException e) {
                MIBPARSINGLOGGERERROR.warn("Can't add new OID %s: %s", i, e.getMessage());
                try {
                    if (!i.getPath(this.buildOids).isEmpty()) {
                        sortedoid.add((Oid)i);
                    }
                }
                catch (MibException e1) {
                    MIBPARSINGLOGGERERROR.warn("Second failure: can't add new OID %s: %s", i, e.getMessage());
                }
            }
            if (isTableEntry) {
                this.tableEntryOid.add((Oid)i);
            }
        });
        return sortedoid;
    }

    void resolve(Syntax syntax) throws MibException {
        syntax.resolve(this.types);
    }

    OidTreeNode resolveNode(Symbol s) {
        try {
            if (this.buildOids.containsKey(s)) {
                Oid o = this.buildOids.get(s);
                return this.nodes.get(o.getPath(this.buildOids));
            }
            return null;
        }
        catch (MibException e) {
            MIBPARSINGLOGGERERROR.warn("Can't resolve node from symbol %s: %s", s, e.getMessage());
            return null;
        }
    }

    void newModule(String currentModule) throws MibException {
        if (this.modules.contains(currentModule)) {
            throw new MibException.DuplicatedModuleException(currentModule);
        }
        this.modules.add(currentModule);
    }

    void addMacroValue(Symbol s, OidPath value) throws MibException {
        this.addOid(s, value, false);
    }

    void addTrapType(Symbol s, Object enterprise, Map<String, Object> attributes, Number trapIndex) throws MibException {
        attributes.put("SYMBOL", s);
        Map traps = this.buildTraps.computeIfAbsent(enterprise, k -> new HashMap());
        if (traps.containsKey(trapIndex.intValue())) {
            throw new MibException.DuplicatedSymbolException(s);
        }
        traps.put(trapIndex.intValue(), attributes);
    }

    void addObjectType(Symbol s, Map<String, Object> attributes, OidPath value) throws MibException {
        ObjectTypeBuilder newtype = new ObjectTypeBuilder(attributes);
        Oid oid = this.addOid(s, value, newtype.isIndexed());
        this.buildObjects.put(oid, newtype);
    }

    public void addTextualConvention(Symbol s, Map<String, Object> attributes) throws MibException {
        if (this.textualConventions.containsKey(s)) {
            throw new MibException.DuplicatedSymbolException(s);
        }
        this.textualConventions.put(s, attributes);
    }

    public void addModuleIdentity(Symbol s, OidPath value) throws MibException {
        this.addOid(s, value, false);
    }

    public void addType(Symbol s, Syntax type) throws MibException {
        if (type instanceof NullSyntax) {
            return;
        }
        if (this.types.containsKey(s)) {
            throw new MibException.DuplicatedSymbolException(s);
        }
        if (s == null || type == null) {
            throw new MibException("Empty settings " + String.valueOf(s) + " " + String.valueOf(type));
        }
        this.types.put(s, type);
    }

    public void addValue(Symbol s, OidPath value) throws MibException {
        this.addOid(s, value, false);
    }

    private Oid addOid(Symbol s, OidPath p, boolean tableEntry) throws MibException {
        p.getAll(tableEntry).forEach(i -> {
            if (i.getName() != null) {
                this.allOids.add((Oid)i);
            }
        });
        Oid oid = new Oid(p.getRoot(), p.getComponents(), s.name);
        this.allOids.add(oid);
        if (tableEntry) {
            this.tableEntryOid.add(oid);
        }
        if (this.buildOids.containsKey(s)) {
            throw new MibException.DuplicatedSymbolException(s);
        }
        this.buildOids.put(s, oid);
        return oid;
    }
}

