/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.parsing;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.parsing.MibLoader;
import fr.jrds.snmpcodec.parsing.ModuleListener;
import fr.jrds.snmpcodec.parsing.WrappedException;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.snmp4j.log.LogLevel;

public class ModuleErrorListener
extends BaseErrorListener {
    private final ModuleListener modulelistener;

    public ModuleErrorListener(ModuleListener modulelistener) {
        this.modulelistener = modulelistener;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        LogLevel loggerLevel = MibLoader.MIBPARSINGLOGGERERROR.getEffectiveLogLevel();
        LogLevel usedLevel = LogLevel.INFO;
        if (e instanceof WrappedException) {
            WrappedException mex = (WrappedException)e;
            if (mex.getRootException() instanceof MibException.DuplicatedModuleException || mex.getRootException() instanceof MibException.DuplicatedSymbolException) {
                usedLevel = LogLevel.DEBUG;
            } else if (mex.getRootException() instanceof NullPointerException) {
                usedLevel = LogLevel.ERROR;
            }
        }
        if (this.modulelistener.firstError && usedLevel.getLevel() >= loggerLevel.getLevel()) {
            MibLoader.MIBPARSINGLOGGERERROR.info(recognizer.getInputStream().getSourceName(), new Object[0]);
            this.modulelistener.firstError = false;
        }
        if (usedLevel.getLevel() == 4) {
            MibLoader.MIBPARSINGLOGGERERROR.debug("    line %s:%s: %s", line, charPositionInLine, msg);
        } else if (usedLevel.getLevel() == 5) {
            MibLoader.MIBPARSINGLOGGERERROR.info("    line %s:%s: %s", line, charPositionInLine, msg);
        }
    }
}

