/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.parsing;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.parsing.ASNBaseListener;
import fr.jrds.snmpcodec.parsing.ASNParser;
import fr.jrds.snmpcodec.parsing.Asn1Type;
import fr.jrds.snmpcodec.parsing.MibLoader;
import fr.jrds.snmpcodec.parsing.MibObject;
import fr.jrds.snmpcodec.parsing.OidPath;
import fr.jrds.snmpcodec.parsing.TypeDescription;
import fr.jrds.snmpcodec.parsing.ValueType;
import fr.jrds.snmpcodec.parsing.WrappedException;
import fr.jrds.snmpcodec.smi.Constraint;
import fr.jrds.snmpcodec.smi.SmiType;
import fr.jrds.snmpcodec.smi.Symbol;
import fr.jrds.snmpcodec.smi.Syntax;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public class ModuleListener
extends ASNBaseListener {
    Parser parser;
    boolean firstError = true;
    private final Deque<Object> stack = new ArrayDeque<Object>();
    private final Map<String, Symbol> symbols = new HashMap<String, Symbol>();
    private final Map<String, String> importedFrom = new HashMap<String, String>();
    private String currentModule = null;
    final MibLoader store;

    ModuleListener(MibLoader store) {
        this.store = store;
    }

    Symbol resolveSymbol(String name) {
        Symbol newSymbol = this.importedFrom.containsKey(name) ? new Symbol(this.importedFrom.get(name), name) : new Symbol(this.currentModule, name);
        this.symbols.put(name, newSymbol);
        return newSymbol;
    }

    private Number fitNumber(BigInteger v) {
        int bitLength = v.bitLength();
        Number finalV = bitLength < 7 ? (Number)((byte)v.intValue()) : (Number)(bitLength < 15 ? (Number)((short)v.intValue()) : (Number)(bitLength < 31 ? (Number)v.intValue() : (Number)(bitLength < 63 ? Long.valueOf(v.longValue()) : v)));
        return finalV;
    }

    private <T> T checkedStackOption(ParserRuleContext ctx, Class<T> expected, Supplier<T> stackOp) {
        if (this.stack.isEmpty()) {
            RecognitionException ex = new RecognitionException("Empty stack", (Recognizer)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx);
            this.parser.notifyErrorListeners(ctx.start, ex.getMessage(), ex);
            throw new IllegalStateException("Inconsistent stack");
        }
        if (!expected.isAssignableFrom(this.stack.peek().getClass())) {
            this.stack.clear();
            RecognitionException ex = new RecognitionException("Inconsistent parsing stack", (Recognizer)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx);
            this.parser.notifyErrorListeners(ctx.start, ex.getMessage(), ex);
            throw new IllegalStateException("Inconsistent stack");
        }
        return stackOp.get();
    }

    private <T> T checkedPop(ParserRuleContext ctx, Class<T> expected) {
        return (T)this.checkedStackOption(ctx, expected, () -> this.stack.pop());
    }

    private <T> T checkedPeek(ParserRuleContext ctx, Class<T> expected) {
        return (T)this.checkedStackOption(ctx, expected, () -> this.stack.peek());
    }

    @Override
    public void enterModuleDefinition(ASNParser.ModuleDefinitionContext ctx) {
        this.currentModule = ctx.IDENTIFIER().getText();
        this.symbols.clear();
        Symbol ccitt = new Symbol("ccitt");
        Symbol iso = new Symbol("iso");
        Symbol joint = new Symbol("joint-iso-ccitt");
        this.symbols.put(ccitt.name, ccitt);
        this.symbols.put(iso.name, iso);
        this.symbols.put(joint.name, joint);
        this.importedFrom.clear();
        try {
            this.store.newModule(this.currentModule);
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void enterSymbolsFromModule(ASNParser.SymbolsFromModuleContext ctx) {
        ctx.symbolList().symbol().forEach(i -> {
            String name = i.getText();
            String module = ctx.globalModuleReference().getText();
            this.importedFrom.put(name, module);
            this.symbols.put(name, new Symbol(module, name));
        });
    }

    @Override
    public void enterAssignment(ASNParser.AssignmentContext ctx) {
        this.stack.clear();
        this.stack.push(this.resolveSymbol(ctx.identifier.getText()));
    }

    @Override
    public void enterComplexAssignement(ASNParser.ComplexAssignementContext ctx) {
        this.stack.push(new MibObject.OtherMacroObject(ctx.macroName().getText()));
    }

    @Override
    public void exitComplexAssignement(ASNParser.ComplexAssignementContext ctx) {
        ValueType.OidValue value = this.checkedPop(ctx, ValueType.OidValue.class);
        MibObject.OtherMacroObject macro = this.checkedPop(ctx, MibObject.OtherMacroObject.class);
        Symbol s = this.checkedPop(ctx, Symbol.class);
        if (value == null || macro == null || s == null) {
            return;
        }
        macro.value = value;
        try {
            this.store.addMacroValue(s, (OidPath)macro.value.value);
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void enterTrapTypeAssignement(ASNParser.TrapTypeAssignementContext ctx) {
        this.stack.push(new MibObject.TrapTypeObject());
    }

    @Override
    public void exitTrapTypeAssignement(ASNParser.TrapTypeAssignementContext ctx) {
        ValueType.IntegerValue value = this.checkedPop(ctx, ValueType.IntegerValue.class);
        MibObject.TrapTypeObject macro = this.checkedPop(ctx, MibObject.TrapTypeObject.class);
        Symbol s = this.checkedPop(ctx, Symbol.class);
        if (value == null || macro == null || s == null) {
            return;
        }
        try {
            if (macro.enterprise != null) {
                this.store.addTrapType(s, macro.enterprise, macro.values, (Number)value.value);
            }
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void enterObjectTypeAssignement(ASNParser.ObjectTypeAssignementContext ctx) {
        this.stack.push(new MibObject.ObjectTypeObject());
    }

    @Override
    public void exitObjectTypeAssignement(ASNParser.ObjectTypeAssignementContext ctx) {
        ValueType.OidValue vt = this.checkedPop(ctx, ValueType.OidValue.class);
        MibObject.ObjectTypeObject macro = this.checkedPop(ctx, MibObject.ObjectTypeObject.class);
        Symbol s = this.checkedPop(ctx, Symbol.class);
        if (vt == null || macro == null || s == null) {
            return;
        }
        try {
            this.store.addObjectType(s, macro.values, (OidPath)vt.value);
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void enterTextualConventionAssignement(ASNParser.TextualConventionAssignementContext ctx) {
        this.stack.push(new MibObject.TextualConventionObject());
    }

    @Override
    public void exitTextualConventionAssignement(ASNParser.TextualConventionAssignementContext ctx) {
        MibObject.TextualConventionObject tc = this.checkedPop(ctx, MibObject.TextualConventionObject.class);
        Symbol s = this.checkedPop(ctx, Symbol.class);
        if (tc == null || s == null) {
            return;
        }
        try {
            this.store.addTextualConvention(s, tc.values);
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void enterModuleIdentityAssignement(ASNParser.ModuleIdentityAssignementContext ctx) {
        this.stack.push(new MibObject.ModuleIdentityObject());
    }

    @Override
    public void exitModuleIdentityAssignement(ASNParser.ModuleIdentityAssignementContext ctx) {
        ValueType.OidValue vt = this.checkedPop(ctx, ValueType.OidValue.class);
        Object revisions = this.checkedPop(ctx, Object.class);
        if (vt == null || revisions == null) {
            return;
        }
        while (!(this.stack.peek() instanceof MibObject.ModuleIdentityObject) && !this.stack.isEmpty()) {
            this.stack.pop();
        }
        MibObject.ModuleIdentityObject mi = this.checkedPop(ctx, MibObject.ModuleIdentityObject.class);
        Symbol s = this.checkedPop(ctx, Symbol.class);
        mi.values.put("revisions", revisions);
        try {
            this.store.addModuleIdentity(s, (OidPath)vt.value);
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void exitTypeAssignment(ASNParser.TypeAssignmentContext ctx) {
        TypeDescription td = this.checkedPop(ctx, TypeDescription.class);
        Symbol s = this.checkedPop(ctx, Symbol.class);
        if (td == null || s == null) {
            return;
        }
        try {
            Syntax sy;
            if ("SNMPv2-SMI".equals(s.module)) {
                switch (s.name) {
                    case "IpAddress": {
                        sy = SmiType.IpAddr;
                        break;
                    }
                    case "Counter32": {
                        sy = SmiType.Counter32;
                        break;
                    }
                    case "Gauge32": {
                        sy = SmiType.Gauge32;
                        break;
                    }
                    case "Unsigned32": {
                        sy = SmiType.Unsigned32;
                        break;
                    }
                    case "TimeTicks": {
                        sy = SmiType.TimeTicks;
                        break;
                    }
                    case "Opaque": {
                        sy = SmiType.Opaque;
                        break;
                    }
                    case "Counter64": {
                        sy = SmiType.Counter64;
                        break;
                    }
                    default: {
                        sy = td.getSyntax(this);
                        break;
                    }
                }
            } else {
                sy = td.getSyntax(this);
            }
            this.store.addType(s, sy);
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void exitValueAssignment(ASNParser.ValueAssignmentContext ctx) {
        ValueType vt = this.checkedPop(ctx, ValueType.class);
        this.checkedPop(ctx, Object.class);
        Symbol s = this.checkedPop(ctx, Symbol.class);
        if (vt == null || s == null) {
            return;
        }
        try {
            if (vt.value instanceof OidPath) {
                OidPath path = (OidPath)vt.value;
                this.store.addValue(s, path);
            }
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void exitAssignmentList(ASNParser.AssignmentListContext ctx) {
        this.stack.clear();
    }

    @Override
    public void exitObjectIdentifierValue(ASNParser.ObjectIdentifierValueContext ctx) {
        ValueType.OidValue stackval = this.checkedPeek(ctx, ValueType.OidValue.class);
        OidPath oidParts = (OidPath)stackval.value;
        if (ctx.IDENTIFIER() != null) {
            String name = ctx.IDENTIFIER().getText();
            oidParts.root = this.symbols.containsKey(name) ? this.symbols.get(name) : new Symbol(this.currentModule, name);
        }
    }

    @Override
    public void enterObjIdComponentsList(ASNParser.ObjIdComponentsListContext ctx) {
        OidPath oidParts = ctx.objIdComponents().stream().map(i -> {
            String name = null;
            if (i.identifier != null) {
                name = i.identifier.getText();
            }
            int number = Integer.parseInt(i.NUMBER().getText());
            return new OidPath.OidComponent(name, number);
        }).collect(OidPath::new, ArrayList::add, ArrayList::addAll);
        this.stack.push(new ValueType.OidValue(oidParts));
    }

    @Override
    public void enterBooleanValue(ASNParser.BooleanValueContext ctx) {
        boolean value = "true".equalsIgnoreCase(ctx.getText());
        ValueType.BooleanValue v = new ValueType.BooleanValue(value);
        this.stack.push(v);
    }

    @Override
    public void enterIntegerValue(ASNParser.IntegerValueContext ctx) {
        try {
            BigInteger v;
            if (ctx.signedNumber() != null) {
                v = new BigInteger(ctx.signedNumber().getText());
            } else if (ctx.hexaNumber() != null) {
                String hexanumber = ctx.hexaNumber().HEXANUMBER().getText();
                v = !(hexanumber = hexanumber.substring(1, hexanumber.length() - 2)).isEmpty() ? new BigInteger(hexanumber, 16) : BigInteger.valueOf(0L);
            } else {
                String binarynumber = ctx.binaryNumber().BINARYNUMBER().getText();
                v = !(binarynumber = binarynumber.substring(1, binarynumber.length() - 2)).isEmpty() ? new BigInteger(binarynumber, 2) : BigInteger.valueOf(0L);
            }
            this.stack.push(new ValueType.IntegerValue(this.fitNumber(v)));
        }
        catch (Exception e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void enterStringValue(ASNParser.StringValueContext ctx) {
        try {
            if (ctx.CSTRING() == null || ctx.CSTRING().getText() == null) {
                NullPointerException e = new NullPointerException();
                this.parser.notifyErrorListeners(ctx.start, ((Throwable)e).getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
            }
            String cstring = ctx.CSTRING().getText();
            cstring = cstring.substring(1, cstring.length() - 1);
            ValueType.StringValue v = new ValueType.StringValue(cstring);
            this.stack.push(v);
        }
        catch (Exception e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void exitComplexAttribut(ASNParser.ComplexAttributContext ctx) {
        if (ctx.name == null) {
            return;
        }
        String name = ctx.name.getText();
        Object value = null;
        if (ctx.IDENTIFIER() != null) {
            value = this.resolveSymbol(ctx.IDENTIFIER().getText());
        } else if (ctx.objects() != null) {
            ArrayList<ValueType> objects = new ArrayList<ValueType>();
            while (this.stack.peek() instanceof ValueType) {
                ValueType vt = this.checkedPop(ctx, ValueType.class);
                objects.add(vt);
            }
            value = objects;
        } else if (ctx.groups() != null) {
            value = ctx.groups().IDENTIFIER().stream().map(ParseTree::getText).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        } else if (ctx.variables() != null) {
            value = ctx.variables().IDENTIFIER().stream().map(ParseTree::getText).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        } else if (ctx.notifications() != null) {
            value = ctx.notifications().IDENTIFIER().stream().map(ParseTree::getText).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        } else if (ctx.augments() != null) {
            value = this.resolveSymbol(ctx.augments().IDENTIFIER().getText());
        } else if (ctx.index() != null) {
            LinkedList<Symbol> types = new LinkedList<Symbol>();
            while (this.stack.peek() instanceof TypeDescription) {
                TypeDescription td = this.checkedPop(ctx, TypeDescription.class);
                if (td.typeDescription == null) continue;
                types.addFirst(this.resolveSymbol(td.typeDescription.toString()));
            }
            value = new ArrayList(types);
        } else if (this.stack.peek() instanceof ValueType) {
            ValueType vt = this.checkedPop(ctx, ValueType.class);
            value = vt.value;
        } else if (this.stack.peek() instanceof TypeDescription) {
            value = this.checkedPop(ctx, TypeDescription.class).getSyntax(this);
        }
        MibObject.MappedObject co = this.checkedPeek(ctx, MibObject.MappedObject.class);
        co.values.put(name.intern(), value);
    }

    @Override
    public void exitEnterpriseAttribute(ASNParser.EnterpriseAttributeContext ctx) {
        Object enterprise;
        if (ctx.IDENTIFIER() != null) {
            enterprise = this.resolveSymbol(ctx.IDENTIFIER().getText());
        } else if (ctx.objectIdentifierValue() != null) {
            ValueType.OidValue value = this.checkedPop(ctx, ValueType.OidValue.class);
            enterprise = value.value;
        } else {
            MibException e = new MibException("Invalid trap");
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
            return;
        }
        MibObject.TrapTypeObject co = this.checkedPeek(ctx, MibObject.TrapTypeObject.class);
        co.enterprise = enterprise;
    }

    @Override
    public void exitAccess(ASNParser.AccessContext ctx) {
        String name = ctx.name.getText();
        String value = ctx.IDENTIFIER().getText().intern();
        MibObject.MappedObject co = this.checkedPeek(ctx, MibObject.MappedObject.class);
        co.values.put(name.intern(), value);
    }

    @Override
    public void exitStatus(ASNParser.StatusContext ctx) {
        String name = ctx.name.getText();
        String value = ctx.IDENTIFIER().getText().intern();
        MibObject.MappedObject co = this.checkedPeek(ctx, MibObject.MappedObject.class);
        co.values.put(name.intern(), value);
    }

    @Override
    public void enterModuleRevisions(ASNParser.ModuleRevisionsContext ctx) {
        this.stack.push(new ArrayList());
    }

    @Override
    public void exitModuleRevision(ASNParser.ModuleRevisionContext ctx) {
        ValueType.StringValue description = this.checkedPop(ctx, ValueType.StringValue.class);
        ValueType.StringValue revision = this.checkedPop(ctx, ValueType.StringValue.class);
        if (description == null || revision == null) {
            return;
        }
        List revisions = this.checkedPeek(ctx, List.class);
        revisions.add(new MibObject.Revision((String)description.value, (String)revision.value));
    }

    @Override
    public void enterModuleComplianceAssignement(ASNParser.ModuleComplianceAssignementContext ctx) {
        this.stack.push(new MibObject.MappedObject("MODULE-COMPLIANCE"));
    }

    @Override
    public void exitModuleComplianceAssignement(ASNParser.ModuleComplianceAssignementContext ctx) {
        ValueType.OidValue value = this.checkedPop(ctx, ValueType.OidValue.class);
        if (value == null) {
            return;
        }
        while (!(this.stack.peek() instanceof Symbol) && !this.stack.isEmpty()) {
            this.stack.pop();
        }
        Symbol s = this.checkedPop(ctx, Symbol.class);
        if (s == null) {
            return;
        }
        try {
            this.store.addMacroValue(s, (OidPath)value.value);
        }
        catch (MibException e) {
            this.parser.notifyErrorListeners(ctx.start, e.getMessage(), (RecognitionException)new WrappedException(e, (Recognizer<?, ?>)this.parser, (org.antlr.v4.runtime.IntStream)this.parser.getInputStream(), ctx));
        }
    }

    @Override
    public void enterType(ASNParser.TypeContext ctx) {
        TypeDescription td;
        block13: {
            block12: {
                td = new TypeDescription();
                if (ctx.builtinType() == null) break block12;
                switch (((ParserRuleContext)ctx.builtinType().getChild(ParserRuleContext.class, 0)).getRuleIndex()) {
                    case 74: {
                        td.type = Asn1Type.integerType;
                        break block13;
                    }
                    case 77: {
                        td.type = Asn1Type.octetStringType;
                        break block13;
                    }
                    case 78: {
                        td.type = Asn1Type.bitStringType;
                        break block13;
                    }
                    case 71: {
                        td.type = Asn1Type.choiceType;
                        break block13;
                    }
                    case 16: {
                        td.type = Asn1Type.sequenceType;
                        break block13;
                    }
                    case 17: {
                        td.type = Asn1Type.sequenceOfType;
                        break block13;
                    }
                    case 76: {
                        td.type = Asn1Type.objectidentifiertype;
                        break block13;
                    }
                    case 51: {
                        td.type = Asn1Type.nullType;
                        break block13;
                    }
                    case 48: {
                        td.type = Asn1Type.bitsType;
                        break block13;
                    }
                    default: {
                        throw new ParseCancellationException();
                    }
                }
            }
            if (ctx.referencedType() != null) {
                td.type = Asn1Type.referencedType;
                td.typeDescription = ctx.referencedType();
            }
        }
        this.stack.push(td);
    }

    @Override
    public void exitType(ASNParser.TypeContext ctx) {
        if (this.stack.peek() instanceof Constraint) {
            Constraint constrains = this.checkedPop(ctx, Constraint.class);
            TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
            td.constraints = constrains;
        }
    }

    @Override
    public void enterConstraint(ASNParser.ConstraintContext ctx) {
        this.stack.push(new Constraint(false));
    }

    @Override
    public void exitConstraint(ASNParser.ConstraintContext ctx) {
        Constraint constrains = this.checkedPeek(ctx, Constraint.class);
        constrains.finish();
    }

    @Override
    public void enterSizeConstraint(ASNParser.SizeConstraintContext ctx) {
        this.stack.push(new Constraint(true));
    }

    @Override
    public void exitSizeConstraint(ASNParser.SizeConstraintContext ctx) {
        Constraint constrains = this.checkedPeek(ctx, Constraint.class);
        constrains.finish();
    }

    @Override
    public void exitElements(ASNParser.ElementsContext ctx) {
        ArrayList<Number> values = new ArrayList<Number>(2);
        while (this.stack.peek() instanceof ValueType.IntegerValue) {
            ValueType.IntegerValue val = this.checkedPop(ctx, ValueType.IntegerValue.class);
            values.add((Number)val.value);
        }
        Constraint.ConstraintElement c = values.size() == 1 ? new Constraint.ConstraintElement((Number)values.get(0)) : new Constraint.ConstraintElement((Number)values.get(1), (Number)values.get(0));
        Constraint constrains = this.checkedPeek(ctx, Constraint.class);
        constrains.add(c);
    }

    @Override
    public void enterSequenceType(ASNParser.SequenceTypeContext ctx) {
        TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
        LinkedHashMap content = new LinkedHashMap();
        td.type = Asn1Type.sequenceType;
        ctx.namedType().forEach(i -> content.put(i.IDENTIFIER().getText(), null));
        td.typeDescription = content;
    }

    @Override
    public void exitSequenceType(ASNParser.SequenceTypeContext ctx) {
        ArrayList<TypeDescription> nt = new ArrayList<TypeDescription>();
        int namedTypeCount = ctx.namedType().size();
        for (int i = 0; i < namedTypeCount; ++i) {
            nt.add(this.checkedPop(ctx, TypeDescription.class));
        }
        AtomicInteger i = new AtomicInteger(nt.size() - 1);
        TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
        Map content = (Map)td.typeDescription;
        content.keySet().forEach(name -> content.put(name, ((TypeDescription)nt.get(i.getAndDecrement())).getSyntax(this)));
    }

    @Override
    public void exitSequenceOfType(ASNParser.SequenceOfTypeContext ctx) {
        TypeDescription seqtd = this.checkedPop(ctx, TypeDescription.class);
        if (seqtd == null) {
            return;
        }
        TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
        td.typeDescription = seqtd;
    }

    @Override
    public void enterChoiceType(ASNParser.ChoiceTypeContext ctx) {
        TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
        LinkedHashMap content = new LinkedHashMap();
        td.type = Asn1Type.choiceType;
        ctx.namedType().forEach(i -> content.put(i.IDENTIFIER().getText(), null));
        td.typeDescription = content;
        this.stack.push("CHOICE");
    }

    @Override
    public void exitChoiceType(ASNParser.ChoiceTypeContext ctx) {
        ArrayList<TypeDescription> nt = new ArrayList<TypeDescription>();
        while (!"CHOICE".equals(this.stack.peek())) {
            nt.add(this.checkedPop(ctx, TypeDescription.class));
        }
        this.stack.pop();
        int i = nt.size() - 1;
        TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
        Map content = (Map)td.typeDescription;
        content.keySet().forEach(name -> content.put(name, ((TypeDescription)nt.get(i)).getSyntax(this)));
    }

    @Override
    public void enterIntegerType(ASNParser.IntegerTypeContext ctx) {
        TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
        if (ctx.namedNumberList() != null) {
            HashMap<Number, String> names = new HashMap<Number, String>();
            ctx.namedNumberList().namedNumber().forEach(i -> {
                BigInteger value = new BigInteger(i.signedNumber().getText());
                String name = i.name.getText();
                names.put(this.fitNumber(value), name);
            });
            td.names = names;
        }
    }

    @Override
    public void enterBitsType(ASNParser.BitsTypeContext ctx) {
        Map bits;
        TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
        if (ctx.bitsEnumeration() != null && ctx.bitsEnumeration().bitDescription() != null) {
            List<ASNParser.BitDescriptionContext> descriptions = ctx.bitsEnumeration().bitDescription();
            bits = new LinkedHashMap(descriptions.size());
            IntStream.range(0, descriptions.size()).forEach(i -> bits.put(((ASNParser.BitDescriptionContext)((Object)((Object)descriptions.get(i)))).IDENTIFIER().getText(), Integer.parseUnsignedInt(((ASNParser.BitDescriptionContext)((Object)((Object)descriptions.get(i)))).NUMBER().getText())));
        } else {
            bits = Collections.emptyMap();
        }
        td.typeDescription = bits;
    }

    @Override
    public void enterReferencedType(ASNParser.ReferencedTypeContext ctx) {
        TypeDescription td = this.checkedPeek(ctx, TypeDescription.class);
        td.typeDescription = ctx.getText();
    }
}

