/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.parsing;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.parsing.IndexBuilder;
import fr.jrds.snmpcodec.parsing.MibLoader;
import fr.jrds.snmpcodec.smi.Index;
import fr.jrds.snmpcodec.smi.ObjectType;
import fr.jrds.snmpcodec.smi.Symbol;
import fr.jrds.snmpcodec.smi.Syntax;
import java.util.List;
import java.util.Map;

public class ObjectTypeBuilder {
    private final Syntax syntax;
    private final boolean indexed;
    private final boolean augments;
    private final IndexBuilder index;
    private final Symbol augmentedEntry;

    ObjectTypeBuilder(Map<String, Object> attributes) {
        this.syntax = (Syntax)attributes.remove("SYNTAX");
        this.indexed = attributes.containsKey("INDEX");
        this.augments = attributes.containsKey("AUGMENTS");
        if (this.indexed) {
            List indexSymbols = (List)attributes.remove("INDEX");
            this.index = new IndexBuilder(indexSymbols);
        } else {
            this.index = null;
        }
        this.augmentedEntry = this.augments ? (Symbol)attributes.remove("AUGMENTS") : null;
    }

    ObjectType resolve(MibLoader loader) throws MibException {
        loader.resolve(this.syntax);
        Index newIndex = null;
        if (this.index != null) {
            newIndex = this.index.resolve(loader);
        }
        return new ObjectType(this.syntax, this.indexed, newIndex);
    }

    ObjectType resolve(MibLoader loader, ObjectTypeBuilder augmented) throws MibException {
        loader.resolve(this.syntax);
        Index newIndex = null;
        if (augmented.index != null) {
            newIndex = augmented.index.resolve(loader);
        }
        return new ObjectType(this.syntax, this.augments, newIndex);
    }

    boolean isIndexed() {
        return this.indexed || this.augments;
    }

    boolean isAugmenter() {
        return this.augments;
    }

    Symbol getAugmented() {
        return this.augmentedEntry;
    }
}

