/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.parsing;

import fr.jrds.snmpcodec.MibException;
import fr.jrds.snmpcodec.smi.Oid;
import fr.jrds.snmpcodec.smi.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OidPath
extends ArrayList<OidComponent> {
    Symbol root;

    OidPath() {
    }

    @Override
    public String toString() {
        return (String)(this.root != null ? String.valueOf(this.root) + "." : "") + this.stream().map(OidComponent::toString).collect(Collectors.joining("."));
    }

    Symbol getRoot() {
        return this.root;
    }

    public List<OidComponent> getComponents() {
        return new ArrayList<OidComponent>(this);
    }

    public Stream<Oid> getAll(boolean tableEntry) {
        ArrayList stack = new ArrayList(this.size());
        return this.stream().map(i -> {
            try {
                ArrayList<OidComponent> newPath = new ArrayList<OidComponent>(stack.size());
                stack.add(i);
                newPath.addAll(stack);
                return new Oid(this.root, newPath, i.name);
            }
            catch (MibException e) {
                throw e.getNonChecked();
            }
        }).limit((long)this.size() - 1L);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OidPath that = (OidPath)o;
        return this.root == null && that.root == null || this.root.equals(that.root);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.root);
    }

    public static class OidComponent {
        public final int number;
        public final String name;

        public OidComponent(String name, int number) {
            this.number = number;
            this.name = name;
        }

        public String toString() {
            return String.format("%s%d%s", this.name != null ? this.name + "(" : "", this.number, this.name != null ? ")" : "");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.number;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OidComponent other = (OidComponent)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.number == other.number;
        }
    }
}

