/*
 * Decompiled with CFR 0.152.
 */
package fr.jrds.snmpcodec.parsing;

import fr.jrds.snmpcodec.parsing.Asn1Type;
import fr.jrds.snmpcodec.parsing.ModuleListener;
import fr.jrds.snmpcodec.parsing.NullSyntax;
import fr.jrds.snmpcodec.smi.AnnotedSyntax;
import fr.jrds.snmpcodec.smi.Bits;
import fr.jrds.snmpcodec.smi.Constraint;
import fr.jrds.snmpcodec.smi.Referenced;
import fr.jrds.snmpcodec.smi.SmiType;
import fr.jrds.snmpcodec.smi.Syntax;
import fr.jrds.snmpcodec.smi.Table;
import fr.jrds.snmpcodec.smi.TableEntry;
import java.util.Map;

public class TypeDescription {
    Asn1Type type;
    Object typeDescription = null;
    Map<Number, String> names;
    Constraint constraints = null;

    public Syntax getSyntax(ModuleListener listener) {
        Syntax trySyntax;
        switch (this.type) {
            case referencedType: {
                trySyntax = new Referenced(listener.resolveSymbol((String)this.typeDescription));
                break;
            }
            case octetStringType: {
                trySyntax = SmiType.OctetString;
                break;
            }
            case integerType: {
                trySyntax = SmiType.INTEGER;
                break;
            }
            case objectidentifiertype: {
                trySyntax = SmiType.ObjID;
                break;
            }
            case nullType: {
                trySyntax = SmiType.Null;
                break;
            }
            case bitsType: {
                Map bitsEnumeration = (Map)this.typeDescription;
                return new Bits(bitsEnumeration, this.constraints);
            }
            case sequenceType: {
                Map columns = (Map)this.typeDescription;
                return new TableEntry(columns);
            }
            case sequenceOfType: {
                TypeDescription td = (TypeDescription)this.typeDescription;
                return new Table(listener.resolveSymbol((String)td.typeDescription));
            }
            default: {
                return new NullSyntax();
            }
        }
        if (this.names != null || this.constraints != null) {
            return new AnnotedSyntax(trySyntax, this.names, this.constraints);
        }
        return trySyntax;
    }

    public String toString() {
        return String.valueOf((Object)this.type) + (String)(this.typeDescription != null ? " " + String.valueOf(this.typeDescription) : "");
    }
}

